/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.RenderUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Matrix4f;

public class HeatBarTooltip
implements TooltipComponent {
    public FormattedCharSequence normalText;
    public float heat;
    public float maxHeat;
    public int barWidth;

    public HeatBarTooltip(FormattedCharSequence normalText, float heat, float maxHeat, int barWidth) {
        this.normalText = normalText;
        this.heat = heat;
        this.maxHeat = maxHeat;
        this.barWidth = barWidth;
    }

    public HeatBarTooltip(FormattedCharSequence normalText, float heat, float maxHeat) {
        this(normalText, heat, maxHeat, 96);
    }

    public static class HeatBarClientTooltip
    implements ClientTooltipComponent {
        HeatBarTooltip tooltip;

        public HeatBarClientTooltip(HeatBarTooltip tooltip) {
            this.tooltip = tooltip;
        }

        public int m_142103_() {
            return 10;
        }

        public int m_142069_(Font font) {
            return font.m_92724_(this.tooltip.normalText) + this.tooltip.barWidth - 24;
        }

        public void m_142440_(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
            font.m_272191_(this.tooltip.normalText, (float)mouseX, (float)mouseY, -1, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }

        public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
            int offset = font.m_92724_(this.tooltip.normalText) + 2;
            float x1 = x + offset + 3;
            float x2 = x + this.tooltip.barWidth - 3;
            float progress = this.tooltip.heat >= this.tooltip.maxHeat ? 1.0f : this.tooltip.heat / (this.tooltip.maxHeat + this.tooltip.maxHeat * 0.1f);
            x2 = x1 + (x2 - x1) * progress;
            for (float j = 0.0f; j < 10.0f; j += 1.0f) {
                float coeff = j / 10.0f;
                float coeff2 = (j + 1.0f) / 10.0f;
                for (float k = 0.0f; k < 4.0f; k += 0.5f) {
                    float thick = k / 4.0f * (this.tooltip.heat >= this.tooltip.maxHeat ? (float)Math.sin((float)EmbersClientEvents.ticks * 0.5f) * 2.0f + 3.0f : 1.0f);
                    RenderUtil.drawColorRectBatched(graphics.m_280168_(), graphics.m_280091_(), x1 * (1.0f - coeff) + x2 * coeff, (float)y + k, 0.0f, (x2 - x1) / 10.0f, 8.0f - 2.0f * k, EmbersColors.EMBER.x, EmbersColors.EMBER.y, EmbersColors.EMBER.z, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff) + x2 * coeff)), 4 * (int)((float)y + k))), EmbersColors.EMBER.x, EmbersColors.EMBER.y, EmbersColors.EMBER.z, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff2) + x2 * coeff2)), 4 * (int)((float)y + k))), EmbersColors.EMBER.x, EmbersColors.EMBER.y, EmbersColors.EMBER.z, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff2) + x2 * coeff2)), 4 * (int)((double)y + (8.0 - (double)k)))), EmbersColors.EMBER.x, EmbersColors.EMBER.y, EmbersColors.EMBER.z, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff) + x2 * coeff)), 4 * (int)((double)y + (8.0 - (double)k)))));
                }
            }
            x1 = x + offset + 3;
            x2 = x + this.tooltip.barWidth - 3;
            float point = x1 + (x2 - x1) * progress;
            float k = 0.0f;
            while (k < 4.0f) {
                float thick = (float)((double)k / 4.0);
                RenderUtil.drawColorRectBatched(graphics.m_280168_(), graphics.m_280091_(), point, (float)y + k, 0.0f, Math.min(x2 - point, (x2 - x1) / 10.0f), 8.0f - 2.0f * k, EmbersColors.EMBER.x, EmbersColors.EMBER.y, EmbersColors.EMBER.z, 1.0f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * point), 4 * (int)((float)y + k))), EmbersColors.EMBER.x * 0.25f, EmbersColors.EMBER.y * 0.25f, EmbersColors.EMBER.z * 0.25f, 0.0f, EmbersColors.EMBER.x * 0.25f, EmbersColors.EMBER.y * 0.25f, EmbersColors.EMBER.z * 0.25f, 0.0f, EmbersColors.EMBER.x, EmbersColors.EMBER.y, EmbersColors.EMBER.z, 1.0f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * point), 4 * (int)((double)y + (8.0 - (double)k)))));
                k = (float)((double)k + 0.5);
            }
            x1 = x + offset + 3;
            x2 = x + this.tooltip.barWidth - 3;
            x1 = x2 - (x2 - x1) * (1.0f - progress);
            for (float j = 0.0f; j < 10.0f; j += 1.0f) {
                float coeff = j / 10.0f;
                float coeff2 = (j + 1.0f) / 10.0f;
                for (float k2 = 0.0f; k2 < 4.0f; k2 += 0.5f) {
                    float thick = (float)((double)k2 / 4.0);
                    RenderUtil.drawColorRectBatched(graphics.m_280168_(), graphics.m_280091_(), x1 * (1.0f - coeff) + x2 * coeff, (float)y + k2, 0.0f, (x2 - x1) / 10.0f, 8.0f - 2.0f * k2, EmbersColors.EMBER.x * 0.25f, EmbersColors.EMBER.y * 0.25f, EmbersColors.EMBER.z * 0.25f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff) + x2 * coeff)), 4 * (int)((float)y + k2))), EmbersColors.EMBER.x * 0.25f, EmbersColors.EMBER.y * 0.25f, EmbersColors.EMBER.z * 0.25f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff2) + x2 * coeff2)), 4 * (int)((float)y + k2))), EmbersColors.EMBER.x * 0.25f, EmbersColors.EMBER.y * 0.25f, EmbersColors.EMBER.z * 0.25f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff2) + x2 * coeff2)), 4 * (int)((double)y + (8.0 - (double)k2)))), EmbersColors.EMBER.x * 0.25f, EmbersColors.EMBER.y * 0.25f, EmbersColors.EMBER.z * 0.25f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((float)(EmbersClientEvents.ticks * 12) + 4.0f * (x1 * (1.0f - coeff) + x2 * coeff)), 4 * (int)((double)y + (8.0 - (double)k2)))));
                }
            }
            RenderUtil.drawHeatBarEnd(graphics.m_280168_(), graphics.m_280091_(), offset + x, y - 1, 0.0f, 8.0f, 10.0f, 0.0f, 0.0f, 0.5f, 0.625f);
            RenderUtil.drawHeatBarEnd(graphics.m_280168_(), graphics.m_280091_(), offset + x + this.tooltip.barWidth - 8 - 26, y - 1, 0.0f, 8.0f, 10.0f, 0.5f, 0.0f, 1.0f, 0.625f);
        }
    }
}

