/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.rekindled.embers.compat.curios.CuriosCompat;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.fml.ModList;

public class MatchCurioLootCondition
implements LootItemCondition {
    public static final LootItemConditionType LOOT_CONDITION_TYPE = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    final ItemPredicate predicate;

    public MatchCurioLootCondition(ItemPredicate pToolPredicate) {
        this.predicate = pToolPredicate;
    }

    public LootItemConditionType m_7940_() {
        return LOOT_CONDITION_TYPE;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81458_, (Object)LootContextParams.f_81455_);
    }

    public boolean test(LootContext context) {
        if (!ModList.get().isLoaded("curios")) {
            return false;
        }
        Entity user = null;
        if (context.m_78936_(LootContextParams.f_81458_)) {
            user = (Entity)context.m_165124_(LootContextParams.f_81458_);
        } else if (context.m_78936_(LootContextParams.f_81455_)) {
            user = (Entity)context.m_165124_(LootContextParams.f_81455_);
        }
        if (user instanceof LivingEntity) {
            return CuriosCompat.checkForCurios((LivingEntity)user, stack -> this.predicate.m_45049_(stack));
        }
        return false;
    }

    public static LootItemCondition.Builder curioMatches(ItemPredicate.Builder pToolPredicateBuilder) {
        return () -> new MatchCurioLootCondition(pToolPredicateBuilder.m_45077_());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<MatchCurioLootCondition> {
        public void serialize(JsonObject p_82013_, MatchCurioLootCondition p_82014_, JsonSerializationContext p_82015_) {
            p_82013_.add("predicate", p_82014_.predicate.m_45048_());
        }

        public MatchCurioLootCondition deserialize(JsonObject p_82021_, JsonDeserializationContext p_82022_) {
            ItemPredicate itempredicate = ItemPredicate.m_45051_((JsonElement)p_82021_.get("predicate"));
            return new MatchCurioLootCondition(itempredicate);
        }
    }
}

