/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.worldgen;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class CaveStructurePiece
extends PoolElementStructurePiece {
    public Structure.GenerationContext context;
    public int maxHeight;

    public CaveStructurePiece(StructureTemplateManager pStructureTemplateManager, StructurePoolElement pElement, BlockPos pPosition, int pGroundLevelDelta, Rotation pRotation, BoundingBox pBox, Structure.GenerationContext context, int maxHeight) {
        super(pStructureTemplateManager, pElement, pPosition, pGroundLevelDelta, pRotation, pBox);
        this.context = context;
        this.maxHeight = maxHeight;
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        BlockPos center = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.m_73547_().m_71056_() / 2, 0, this.m_73547_().m_71058_() / 2), (Mirror)Mirror.NONE, (Rotation)this.m_6830_(), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)this.f_72598_);
        int caveHeight = CaveStructurePiece.getCaveFloor(center, this.maxHeight, worldGenLevel, this.context);
        if (caveHeight != Integer.MIN_VALUE) {
            this.f_72598_ = new BlockPos(this.f_72598_.m_123341_(), caveHeight, this.f_72598_.m_123343_());
            super.m_213694_(worldGenLevel, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, new BlockPos(pos.m_123341_(), caveHeight, pos.m_123343_()));
        }
    }

    public static int getCaveFloor(BlockPos endPos, int maxHeight, WorldGenLevel level, Structure.GenerationContext context) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(endPos.m_123341_(), level.m_141937_() + 9, endPos.m_123343_());
        for (int i = level.m_141937_() + 9; i <= endPos.m_123342_() && i <= maxHeight; ++i) {
            boolean solid = !level.m_8055_((BlockPos)pos).m_247087_();
            pos.m_142448_(i + 1);
            boolean replaceable = level.m_8055_((BlockPos)pos).m_247087_();
            if (!solid || !replaceable || !CaveStructurePiece.isValidBiome((BlockPos)pos, context)) continue;
            heights.add(i);
        }
        if (heights.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        if (heights.size() > 1) {
            return (Integer)heights.get(1);
        }
        return (Integer)heights.get(0);
    }

    public static boolean isValidBiome(BlockPos blockpos, Structure.GenerationContext pContext) {
        return pContext.f_226630_().test(pContext.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)blockpos.m_123341_()), QuartPos.m_175400_((int)blockpos.m_123342_()), QuartPos.m_175400_((int)blockpos.m_123343_()), pContext.f_226624_().m_224579_()));
    }
}

