/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.handlers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dmr.DragonMounts.client.gui.CommandMenu.CommandMenuScreen;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.network.packets.DragonCommandPacket;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="dmr", value={Dist.CLIENT})
public class CommandOverlayHandler {
    public static Color selectedColor = new Color(163, 163, 163, 200);
    public static Color unselectedColor = new Color(98, 98, 98, 128);
    static final MenuItem[] activeArray = new MenuItem[]{new MenuItem((Component)Component.translatable((String)"dmr.command_mode.sit"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.SIT), (CustomPacketPayload[])new CustomPacketPayload[0])), new MenuItem((Component)Component.translatable((String)"dmr.command_mode.follow"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.FOLLOW), (CustomPacketPayload[])new CustomPacketPayload[0])), new MenuItem((Component)Component.translatable((String)"dmr.command_mode.wander"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.WANDER), (CustomPacketPayload[])new CustomPacketPayload[0])), new MenuItem((Component)Component.translatable((String)"dmr.command_mode.whistle"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.WHISTLE), (CustomPacketPayload[])new CustomPacketPayload[0])), new MenuItem((Component)Component.translatable((String)"dmr.command_mode.passive"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.PASSIVE), (CustomPacketPayload[])new CustomPacketPayload[0])), new MenuItem((Component)Component.translatable((String)"dmr.command_mode.neutral"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.NEUTRAL), (CustomPacketPayload[])new CustomPacketPayload[0])), new MenuItem((Component)Component.translatable((String)"dmr.command_mode.aggressive"), player -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonCommandPacket(DragonCommandPacket.Command.AGGRESSIVE), (CustomPacketPayload[])new CustomPacketPayload[0]))};
    public static final int MAX_ITEMS = activeArray.length;
    public static final double ANGLE_PER_ITEM = 360.0f / (float)MAX_ITEMS;
    public static final float OUTER_RADIUS = 50.0f;
    public static final float INNER_RADIUS = 10.0f;
    public static int animationTimer = 20;

    public static void tickTimer() {
        if (animationTimer > 0) {
            animationTimer -= 5;
        }
    }

    public static void resetTimer() {
        animationTimer = 20;
    }

    public static double getMouseAngle() {
        Minecraft mc = Minecraft.getInstance();
        return CommandOverlayHandler.getRelativeAngle((double)mc.getWindow().getScreenWidth() * 0.5, (double)mc.getWindow().getScreenHeight() * 0.5, mc.mouseHandler.xpos(), mc.mouseHandler.ypos());
    }

    private static double getRelativeAngle(double originX, double originY, double x, double y) {
        double angle = -Math.toDegrees(Math.atan2(x - originX, y - originY));
        return CommandOverlayHandler.correctAngle(angle);
    }

    public static double correctAngle(double angle) {
        if (angle < 0.0) {
            angle += 360.0;
        } else if (angle > 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public static MenuItem[] getItems() {
        return activeArray;
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        CommandOverlayHandler.tickTimer();
        Minecraft mc = Minecraft.getInstance();
        if ((mc.level == null || mc.isPaused()) && CommandMenuScreen.active) {
            CommandMenuScreen.deactivate();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.TAB_LIST)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && !mc.options.hideGui && !mc.isPaused() && CommandMenuScreen.active) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            CommandOverlayHandler.renderButtonBackgrounds();
            CommandOverlayHandler.renderItems(guiGraphics);
        }
    }

    public static void renderButtonBackgrounds() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        assert (player != null);
        DragonWhistleItem whistleItem = DragonWhistleHandler.getDragonWhistleItem((Player)player);
        if (whistleItem == null) {
            return;
        }
        double mouseAngle = CommandOverlayHandler.correctAngle(CommandOverlayHandler.getMouseAngle() + 1.5 * ANGLE_PER_ITEM);
        double mouseDistance = CommandOverlayHandler.getMouseDistance();
        CommandOverlayHandler.doSectionRender(bufferBuilder -> {
            for (int i = 0; i < MAX_ITEMS; ++i) {
                Color bgColor;
                boolean mouseIn;
                double trueSegStart = ANGLE_PER_ITEM * (double)i;
                double trueSegEnd = ANGLE_PER_ITEM * (double)(i + 1);
                boolean bl = mouseIn = mouseAngle > trueSegStart && mouseAngle < trueSegEnd;
                if (mouseDistance < 10.0 || mouseDistance > 65.0) {
                    mouseIn = false;
                }
                float innerRadius = (10.0f - (float)animationTimer) / 100.0f * 130.0f;
                float outerRadius = (50.0f - (float)animationTimer) / 100.0f * 130.0f;
                Color color = mouseIn ? selectedColor : unselectedColor;
                Color bsColor = new Color(whistleItem.getColor().getTextureDiffuseColor());
                bsColor = new Color(bsColor.getRed(), bsColor.getGreen(), bsColor.getBlue(), color.getAlpha());
                Color color2 = bgColor = ClientConfig.COLORED_WHISTLE_MENU ? bsColor : color;
                if (mouseIn) {
                    bgColor = bgColor.darker();
                }
                int subdivisions = 2;
                for (int j = 0; j < subdivisions; ++j) {
                    double t1 = (double)j / (double)subdivisions;
                    double t2 = (double)(j + 1) / (double)subdivisions;
                    CommandOverlayHandler.renderSection(bufferBuilder, bgColor, outerRadius, innerRadius, trueSegStart + 0.25, trueSegEnd - 0.5, t1, t2);
                    CommandOverlayHandler.renderSection(bufferBuilder, bgColor.darker(), innerRadius, 10.0f, trueSegStart, trueSegEnd, t1, t2);
                }
            }
        });
    }

    public static double getMouseDistance() {
        Minecraft mc = Minecraft.getInstance();
        float centerX = (float)((double)mc.getWindow().getGuiScaledWidth() * 0.5);
        float centerY = (float)((double)mc.getWindow().getGuiScaledHeight() * 0.5);
        double scaleX = (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth();
        double scaleY = (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
        double guiMouseX = mc.mouseHandler.xpos() * scaleX;
        double guiMouseY = mc.mouseHandler.ypos() * scaleY;
        double dx = guiMouseX - (double)centerX;
        double dy = guiMouseY - (double)centerY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static void doSectionRender(SectionRender runnable) {
        Minecraft mc = Minecraft.getInstance();
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        float centerX = (float)((double)mc.getWindow().getGuiScaledWidth() * 0.5);
        float centerY = (float)((double)mc.getWindow().getGuiScaledHeight() * 0.5);
        matrix.translate(centerX, centerY, 0.0f);
        matrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(12.8f));
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        runnable.render(bufferBuilder);
        try (MeshData data = bufferBuilder.build();){
            if (data != null) {
                BufferUploader.drawWithShader((MeshData)data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrix.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderSection(BufferBuilder bufferBuilder, Color color, float outerRadius, float innerRadius, double trueSegStart, double trueSegEnd) {
        CommandOverlayHandler.renderSection(bufferBuilder, color, outerRadius, innerRadius, trueSegStart, trueSegEnd, 1.0, 2.0);
    }

    private static void renderSection(BufferBuilder bufferBuilder, Color color, float outerRadius, float innerRadius, double trueSegStart, double trueSegEnd, double t1, double t2) {
        double angle1 = Math.toRadians(trueSegStart + t1 * (trueSegEnd - trueSegStart));
        double angle2 = Math.toRadians(trueSegStart + t2 * (trueSegEnd - trueSegStart));
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        float xOuter1 = (float)(Math.cos(angle1) * (double)outerRadius);
        float yOuter1 = (float)(Math.sin(angle1) * (double)outerRadius);
        float xOuter2 = (float)(Math.cos(angle2) * (double)outerRadius);
        float yOuter2 = (float)(Math.sin(angle2) * (double)outerRadius);
        float xInner2 = (float)(Math.cos(angle2) * (double)innerRadius);
        float yInner2 = (float)(Math.sin(angle2) * (double)innerRadius);
        float xInner1 = (float)(Math.cos(angle1) * (double)innerRadius);
        float yInner1 = (float)(Math.sin(angle1) * (double)innerRadius);
        bufferBuilder.addVertex(xOuter1, yOuter1, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(xOuter2, yOuter2, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(xInner2, yInner2, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(xInner1, yInner1, 0.0f).setColor(r, g, b, a);
    }

    public static void renderItems(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        Font fontRenderer = mc.font;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)window.getGuiScaledWidth() * 0.5, (double)window.getGuiScaledHeight() * 0.5, 0.0);
        for (int i = 0; i < MAX_ITEMS; ++i) {
            MenuItem item = CommandOverlayHandler.getItems()[i];
            float innerRadius = (10.0f - (float)animationTimer) / 100.0f * 130.0f;
            float outerRadius = (50.0f - (float)animationTimer) / 100.0f * 130.0f;
            innerRadius = (outerRadius - innerRadius) / 2.0f + 10.0f;
            double trueSegStart = ANGLE_PER_ITEM * (double)i;
            double trueSegEnd = ANGLE_PER_ITEM * (double)(i + 1);
            double angle1 = Math.toRadians(trueSegStart + (trueSegEnd - trueSegStart));
            double angle2 = Math.toRadians(trueSegStart + 2.0 * (trueSegEnd - trueSegStart));
            float xInner1 = (float)(Math.cos(angle1) * (double)innerRadius);
            float yInner1 = (float)(Math.sin(angle1) * (double)innerRadius);
            float xInner2 = (float)(Math.cos(angle2) * (double)innerRadius);
            float yInner2 = (float)(Math.sin(angle2) * (double)innerRadius);
            float dx = xInner2 - xInner1;
            float dy = yInner2 - yInner1;
            float w = (float)Math.sqrt(dx * dx + dy * dy) * 0.85f;
            float h = (outerRadius - innerRadius) * 0.85f;
            int width = (int)Math.ceil(w);
            int height = (int)Math.ceil(h);
            double angle = ANGLE_PER_ITEM * (double)i - 12.8;
            double textDistance = 45.0f - (float)animationTimer;
            double textX = textDistance * Math.cos(Math.toRadians(angle)) - (double)((float)width * 0.5f);
            double textY = textDistance * Math.sin(Math.toRadians(angle)) - ANGLE_PER_ITEM * 0.25;
            Component string = item.title();
            poseStack.pushPose();
            poseStack.translate(textX, textY, 0.0);
            poseStack.scale(0.5f, 0.5f, 1.0f);
            List lines = ComponentRenderUtils.wrapComponents((FormattedText)string, (int)((int)((float)width * 2.2f)), (Font)fontRenderer);
            float f = (float)height * 2.0f;
            Objects.requireNonNull(fontRenderer);
            float maxLines = f / 9.0f;
            float leftover = maxLines - (float)lines.size();
            float f2 = leftover / 2.0f;
            Objects.requireNonNull(fontRenderer);
            int yOffset = Math.round(f2 * 9.0f);
            int bColor = mc.options.getBackgroundColor(0.25f);
            if (bColor != 0) {
                int fontWidth = lines.stream().mapToInt(arg_0 -> ((Font)fontRenderer).width(arg_0)).max().orElse(0);
                int n = lines.size();
                Objects.requireNonNull(fontRenderer);
                int linesHeight = n * 9;
                int minX = width - 2 - fontWidth / 2;
                int minY = yOffset - 2;
                int maxX = width + 2 + fontWidth / 2;
                int maxY = yOffset + linesHeight + 2;
                guiGraphics.fill(minX, minY, maxX, maxY, bColor);
            }
            for (FormattedCharSequence line : lines) {
                guiGraphics.drawCenteredString(fontRenderer, line, width, yOffset, 0xFFFFFF);
                Objects.requireNonNull(fontRenderer);
                yOffset += 9;
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public record MenuItem(Component title, MenuItemClickListener clickListener) {
    }

    @FunctionalInterface
    public static interface SectionRender {
        public void render(BufferBuilder var1);
    }

    @FunctionalInterface
    public static interface MenuItemClickListener {
        public void onClick(LocalPlayer var1);
    }
}

