/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.model;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.server.blockentities.DMREggBlockEntity;
import dmr.DragonMounts.server.blocks.BlankEggBlock;
import dmr.DragonMounts.server.items.BlankDragonEggItemBlock;
import dmr.DragonMounts.types.dragonBreeds.DragonHybridBreed;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class DragonEggModel
implements IUnbakedGeometry<DragonEggModel> {
    private final ImmutableMap<String, BlockModel> models;

    public DragonEggModel(ImmutableMap<String, BlockModel> models) {
        this.models = models;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        ImmutableMap.Builder baked = ImmutableMap.builder();
        for (Map.Entry entry : this.models.entrySet()) {
            BlockModel unbaked = (BlockModel)entry.getValue();
            unbaked.resolveParents(arg_0 -> ((ModelBaker)baker).getModel(arg_0));
            baked.put((Object)((String)entry.getKey()), (Object)unbaked.bake(baker, unbaked, spriteGetter, modelState, true));
        }
        return new Baked((ImmutableMap<String, BakedModel>)baked.build(), overrides);
    }

    public static class Baked
    implements IDynamicBakedModel {
        public static final Supplier<BakedModel> FALLBACK = Suppliers.memoize(() -> Minecraft.getInstance().getBlockRenderer().getBlockModel(Blocks.DRAGON_EGG.defaultBlockState()));
        public final ImmutableMap<String, BakedModel> models;
        private final ItemOverrides overrides;

        public Baked(ImmutableMap<String, BakedModel> models, ItemOverrides overrides) {
            this.models = models;
            this.overrides = new ItemModelResolver(this, overrides);
        }

        public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            if (state.getBlock() instanceof BlankEggBlock) {
                return ((BakedModel)this.models.get((Object)"blank")).getQuads(state, side, rand, extraData, renderType);
            }
            Data data = (Data)extraData.get(Data.PROPERTY);
            if (data != null) {
                String variantId;
                String breedId = data.breedId();
                if (this.models.containsKey((Object)(breedId + "$" + (variantId = data.variantId())))) {
                    return ((BakedModel)this.models.get((Object)(breedId + "$" + variantId))).getQuads(state, side, rand, extraData, renderType);
                }
                if (this.models.containsKey((Object)breedId)) {
                    return ((BakedModel)this.models.get((Object)breedId)).getQuads(state, side, rand, extraData, renderType);
                }
            }
            return FALLBACK.get().getQuads(state, side, rand, extraData, renderType);
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return FALLBACK.get().getParticleIcon();
        }

        public TextureAtlasSprite getParticleIcon(ModelData modelData) {
            Data data = (Data)modelData.get(Data.PROPERTY);
            if (data != null) {
                String variantId;
                String breedId = data.breedId();
                if (this.models.containsKey((Object)(breedId + "$" + (variantId = data.variantId())))) {
                    return ((BakedModel)this.models.get((Object)(breedId + "$" + variantId))).getParticleIcon(modelData);
                }
                if (this.models.containsKey((Object)breedId)) {
                    return ((BakedModel)this.models.get((Object)breedId)).getParticleIcon(modelData);
                }
            }
            return this.getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return this.overrides;
        }

        public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            return FALLBACK.get().applyTransform(transformType, poseStack, applyLeftHandTransform);
        }

        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            DMREggBlockEntity e;
            if (level.getBlockState(pos).getBlock() instanceof BlankEggBlock) {
                return modelData.derive().with(Data.PROPERTY, (Object)new Data("blank", null)).build();
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof DMREggBlockEntity && (e = (DMREggBlockEntity)blockEntity).getBreed() != null) {
                IDragonBreed iDragonBreed;
                IDragonBreed iDragonBreed2 = e.getBreed();
                if (iDragonBreed2 instanceof DragonHybridBreed) {
                    DragonHybridBreed hybridBreed = (DragonHybridBreed)iDragonBreed2;
                    iDragonBreed = hybridBreed.parent1;
                } else {
                    iDragonBreed = e.getBreed();
                }
                IDragonBreed breed = iDragonBreed;
                return modelData.derive().with(Data.PROPERTY, (Object)new Data(breed.getId(), e.getVariantId())).build();
            }
            return modelData;
        }
    }

    public static class ItemModelResolver
    extends ItemOverrides {
        private final Baked owner;
        private final ItemOverrides nested;

        public ItemModelResolver(Baked owner, ItemOverrides nested) {
            this.owner = owner;
            this.nested = nested;
        }

        public BakedModel resolve(BakedModel original, ItemStack stack, ClientLevel level, LivingEntity entity, int pSeed) {
            BakedModel model;
            IDragonBreed breedObject;
            if (stack.getItem() instanceof BlankDragonEggItemBlock) {
                return (BakedModel)this.owner.models.get((Object)"blank");
            }
            BakedModel override = this.nested.resolve(original, stack, level, entity, pSeed);
            if (override != original) {
                return override;
            }
            String breed = (String)stack.getOrDefault(ModComponents.DRAGON_BREED, (Object)DragonBreedsRegistry.getDefault().getId());
            String variantId = (String)stack.get(ModComponents.DRAGON_VARIANT);
            if (breed.startsWith("hybrid_") && (breedObject = DragonBreedsRegistry.getDragonBreed(breed)) instanceof DragonHybridBreed) {
                DragonHybridBreed hybridBreed = (DragonHybridBreed)breedObject;
                breed = hybridBreed.parent1.getId();
            }
            BakedModel bakedModel = model = variantId != null ? (BakedModel)this.owner.models.get((Object)String.join((CharSequence)"$", breed, variantId)) : (BakedModel)this.owner.models.get((Object)breed);
            if (model != null) {
                return model;
            }
            return original;
        }
    }

    private record Data(String breedId, String variantId) {
        private static final ModelProperty<Data> PROPERTY = new ModelProperty();
    }
}

