/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dmr.DragonMounts.client.model.DragonEggModel;
import dmr.DragonMounts.server.blockentities.DMRBlankEggBlockEntity;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;

public class BlankEggRenderer
implements BlockEntityRenderer<DMRBlankEggBlockEntity> {
    public void render(DMRBlankEggBlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockEntity.getBlockState());
        if (model instanceof DragonEggModel.Baked) {
            DragonEggModel.Baked eggModel = (DragonEggModel.Baked)model;
            BakedModel bakedModel = (BakedModel)eggModel.models.getOrDefault((Object)"blank", (Object)DragonEggModel.Baked.FALLBACK.get());
            poseStack.pushPose();
            int time = blockEntity.getChangeTime();
            blockEntity.renderProgress = Mth.lerp((float)0.5f, (float)blockEntity.renderProgress, (float)time);
            float renderProg = blockEntity.renderProgress / 60.0f;
            RenderType renderType = RenderTypeHelper.getEntityRenderType((RenderType)((RenderType)model.getRenderTypes(blockEntity.getBlockState(), blockEntity.getLevel().random, blockEntity.getModelData()).asList().getFirst()), (boolean)true);
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(renderType), blockEntity.getBlockState(), Objects.requireNonNullElse(bakedModel, model), 0.0f, 0.0f, 0.0f, i, OverlayTexture.NO_OVERLAY);
            if (blockEntity.getTargetBreedId() != null && !blockEntity.getTargetBreedId().isEmpty()) {
                BakedModel targetModel = (BakedModel)eggModel.models.getOrDefault((Object)blockEntity.getTargetBreedId(), (Object)DragonEggModel.Baked.FALLBACK.get());
                poseStack.pushPose();
                RenderType secondRenderType = RenderTypeHelper.getEntityRenderType((RenderType)((RenderType)targetModel.getRenderTypes(blockEntity.getBlockState(), blockEntity.getLevel().random, blockEntity.getModelData()).asList().getFirst()), (boolean)true);
                MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MultiplyAlphaRenderTypeBuffer(multiBufferSource, renderProg);
                Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), multiplyAlphaRenderTypeBuffer.getBuffer(secondRenderType), blockEntity.getBlockState(), Objects.requireNonNullElse(targetModel, model), 0.0f, 0.0f, 0.0f, i, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    public static class MultiplyAlphaRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float constantAlpha;

        public MultiplyAlphaRenderTypeBuffer(MultiBufferSource inner, float constantAlpha) {
            this.inner = inner;
            this.constantAlpha = constantAlpha;
        }

        public VertexConsumer getBuffer(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).state.textureState).texture.orElse(InventoryMenu.BLOCK_ATLAS);
                localType = RenderType.entityTranslucentCull((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.translucentCullBlockSheet().toString())) {
                localType = Sheets.translucentCullBlockSheet();
            }
            return new CVertexConsumer(this.inner.getBuffer(localType), this.constantAlpha);
        }
    }

    public static class CVertexConsumer
    extends VertexConsumerWrapper {
        private float alpha;
        private float red = -1.0f;
        private float green = -1.0f;
        private float blue = -1.0f;

        public CVertexConsumer(VertexConsumer parent, float alpha) {
            super(parent);
            this.alpha = alpha;
        }

        public CVertexConsumer(VertexConsumer parent, float alpha, float red, float green, float blue) {
            super(parent);
            this.alpha = alpha;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public VertexConsumer setColor(int r, int g, int b, int a) {
            if (this.red == -1.0f) {
                this.parent.setColor(r, g, b, Math.round(255.0f * this.alpha));
            } else {
                int rCol = (int)Mth.lerp((float)this.red, (float)0.0f, (float)r);
                int gCol = (int)Mth.lerp((float)this.green, (float)0.0f, (float)g);
                int bCol = (int)Mth.lerp((float)this.blue, (float)0.0f, (float)b);
                this.parent.setColor(rCol, gCol, bCol, Math.round(255.0f * this.alpha));
            }
            return this;
        }
    }
}

