/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.client.renderer.layers.DragonArmorLayer;
import dmr.DragonMounts.client.renderer.layers.DragonGlowLayer;
import dmr.DragonMounts.client.renderer.layers.DragonPassengerLayer;
import dmr.DragonMounts.client.renderer.layers.DragonSaddleLayer;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.ResourcePackLoader;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DragonRenderer
extends GeoEntityRenderer<TameableDragonEntity> {
    public DragonRenderer(EntityRendererProvider.Context renderManager, GeoModel<TameableDragonEntity> modelProvider) {
        super(renderManager, modelProvider);
        this.renderLayers.addLayer((GeoRenderLayer)new DragonGlowLayer((GeoRenderer<TameableDragonEntity>)this));
        this.renderLayers.addLayer((GeoRenderLayer)new DragonArmorLayer((GeoRenderer<TameableDragonEntity>)this));
        this.renderLayers.addLayer((GeoRenderLayer)new DragonSaddleLayer((GeoRenderer<TameableDragonEntity>)this));
        this.renderLayers.addLayer(new DragonPassengerLayer(this, "rider"));
    }

    public RenderType getRenderType(TameableDragonEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutout((ResourceLocation)texture);
    }

    public void render(TameableDragonEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().push("dragon_mounts");
        }
        IDragonBreed breed = entity.getBreed();
        GeoModel model = this.getGeoModel();
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().push("model_properties");
        }
        ResourcePackLoader.negativeModelProperties.forEach((key, bones) -> {
            for (String s : bones) {
                model.getBone(s).ifPresent(geoBone -> geoBone.setHidden(false));
            }
        });
        ResourcePackLoader.modelProperties.forEach((key, bones) -> {
            for (String s : bones) {
                model.getBone(s).ifPresent(geoBone -> geoBone.setHidden(true));
            }
        });
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
            Minecraft.getInstance().getProfiler().push("accessories");
        }
        List<String> accessories = breed.getAccessories();
        for (String key2 : accessories) {
            if (ResourcePackLoader.negativeModelProperties.containsKey(key2)) {
                for (String s : ResourcePackLoader.negativeModelProperties.get(key2)) {
                    model.getBone(s).ifPresent(geoBone -> geoBone.setHidden(true));
                }
            }
            if (!ResourcePackLoader.modelProperties.containsKey(key2)) continue;
            for (String bone2 : ResourcePackLoader.modelProperties.get(key2)) {
                model.getBone(bone2).ifPresent(geoBone -> geoBone.setHidden(false));
            }
        }
        Optional backSpike = model.getBone("backspike3");
        backSpike.ifPresent(geoBone -> geoBone.setHidden(entity.isSaddled()));
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
            Minecraft.getInstance().getProfiler().push("scale");
        }
        if (!entity.isAdult()) {
            float scale = 0.25f + entity.getAgeProgress() * 0.75f;
            stack.scale(scale, scale, scale);
        }
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
            Minecraft.getInstance().getProfiler().push("render");
        }
        try {
            super.render((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        }
        catch (Exception e) {
            if (!stack.clear()) {
                stack.popPose();
            }
            DMR.LOGGER.warn("Error rendering dragon: {}", (Object)e.getMessage());
            return;
        }
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
            Minecraft.getInstance().getProfiler().push("breath_source_position");
        }
        model.getBone("bottomjaw").ifPresent(bone -> entity.setBreathSourcePosition(bone.getLocalPosition()));
        if (entity.hasBreathAttack() && entity.hasBreathTarget()) {
            if (DMR.DEBUG) {
                Minecraft.getInstance().getProfiler().push("breath_rendering");
            }
            entity.renderDragonBreath();
            if (DMR.DEBUG) {
                Minecraft.getInstance().getProfiler().pop();
            }
        }
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
            Minecraft.getInstance().getProfiler().pop();
        }
    }

    public void applyRenderLayers(PoseStack poseStack, TameableDragonEntity animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().push("dragon_layers");
        }
        super.applyRenderLayers(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
        }
    }

    public void actuallyRender(PoseStack poseStack, TameableDragonEntity animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().push("dragon_render");
        }
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
        }
    }

    public void renderRecursively(PoseStack poseStack, TameableDragonEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().push(bone.getName());
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
        }
    }
}

