/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.renderer.layers;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DragonGlowLayer
extends GeoRenderLayer<TameableDragonEntity> {
    private static final Function<ResourceLocation, RenderType> RENDER_TYPE_FUNCTION = Util.memoize(texture -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.create((String)"dragon_glow_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_EYES_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderType.COLOR_WRITE).createCompositeState(false));
    });

    public DragonGlowLayer(GeoRenderer<TameableDragonEntity> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStackIn, TameableDragonEntity entityLivingBaseIn, BakedGeoModel bakedModel, RenderType renderType1, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Optional resourceOptional;
        IDragonBreed breed = entityLivingBaseIn.getBreed();
        ResourceLocation breedResourceLocation = breed.getResourceLocation();
        ResourceLocation glowTexture = DMR.id("textures/entity/dragon/" + breedResourceLocation.getPath() + "/glow.png");
        if (entityLivingBaseIn.hasVariant() && entityLivingBaseIn.getVariant().glowTexture() != null) {
            glowTexture = entityLivingBaseIn.getVariant().glowTexture();
        }
        if ((resourceOptional = Minecraft.getInstance().getResourceManager().getResource(glowTexture)).isEmpty()) {
            return;
        }
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().push("glow_layer");
        }
        RenderType renderType = RENDER_TYPE_FUNCTION.apply(glowTexture);
        this.getRenderer().reRender(bakedModel, matrixStackIn, bufferSource, (GeoAnimatable)entityLivingBaseIn, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.opaque((int)0xFFFFFF));
        if (DMR.DEBUG) {
            Minecraft.getInstance().getProfiler().pop();
        }
    }
}

