/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonStatePacket
extends AbstractMessage<DragonStatePacket> {
    public static final StreamCodec<FriendlyByteBuf, DragonStatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonStatePacket::getEntityId, (StreamCodec)ByteBufCodecs.INT, DragonStatePacket::getState, DragonStatePacket::new);
    private final int entityId;
    private final int state;

    DragonStatePacket() {
        this.entityId = -1;
        this.state = -1;
    }

    public DragonStatePacket(int entityId, int state) {
        this.entityId = entityId;
        this.state = state;
    }

    @Override
    protected String getTypeName() {
        return "dragon_state";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonStatePacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean autoSync() {
        return true;
    }

    @Override
    public void handle(IPayloadContext supplier, Player player) {
        TameableDragonEntity dragon;
        Level level = player.level;
        Entity entity = level.getEntity(this.getEntityId());
        if (entity instanceof TameableDragonEntity && (dragon = (TameableDragonEntity)entity).getControllingPassenger() == null) {
            switch (this.getState()) {
                case 0: {
                    dragon.setWanderTarget(Optional.empty());
                    dragon.setOrderedToSit(true);
                    break;
                }
                case 1: {
                    dragon.setOrderedToSit(false);
                    dragon.setWanderTarget(Optional.empty());
                    break;
                }
                case 2: {
                    dragon.setOrderedToSit(false);
                    dragon.setWanderTarget((Optional)Optional.of(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)player.blockPosition())));
                }
            }
        }
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public int getState() {
        return this.state;
    }
}

