/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.util;

public class MiscUtils {
    public static float[] rgbToHsv(float r, float g, float b) {
        float saturation;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float hue = 0.0f;
        float f = saturation = max == 0.0f ? 0.0f : delta / max;
        if (delta != 0.0f) {
            if (max == r) {
                hue = (g - b) / delta;
                if (g < b) {
                    hue += 6.0f;
                }
            } else {
                hue = max == g ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta;
            }
            hue /= 6.0f;
        }
        return new float[]{hue, saturation, max};
    }

    public static float[] hsvToRgb(float h, float s, float v) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (s == 0.0f) {
            g = b = v;
            r = b;
            return new float[]{r, g, b};
        }
        int i = (int)Math.floor(h *= 6.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new float[]{r, g, b};
    }
}

