/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.util.type_adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;

public class ParticleOptionsAdapter
implements JsonDeserializer<ParticleOptions>,
JsonSerializer<ParticleOptions> {
    public ParticleOptions deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String str = "";
        if (json.isJsonPrimitive()) {
            str = json.getAsString();
        } else if (json.isJsonObject()) {
            str = json.getAsJsonObject().get("type").getAsString();
        }
        StringReader reader = new StringReader(str);
        try {
            ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.read((StringReader)reader));
            CompoundTag compoundtag = reader.canRead() && reader.peek() == '{' ? new TagParser(reader).readStruct() : new CompoundTag();
            return (ParticleOptions)particleType.codec().codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)ParticleArgument.ERROR_INVALID_OPTIONS).create(arg_0));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonElement serialize(ParticleOptions src, Type typeOfSrc, JsonSerializationContext context) {
        return (JsonElement)ParticleTypes.CODEC.encode((Object)src, (DynamicOps)JsonOps.INSTANCE, null).getOrThrow();
    }
}

