/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.api.bus.device.object;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.object.Callbacks;
import li.cil.oc2.api.bus.device.object.LifecycleAwareDevice;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCEventSource;
import li.cil.oc2.api.bus.device.rpc.RPCMethodGroup;

public final class ObjectDevice
implements RPCDevice,
ItemDevice {
    private final Object object;
    private final ArrayList<String> typeNames;
    private final List<RPCMethodGroup> methods;
    private final String className;

    public ObjectDevice(Object object, List<String> typeNames) {
        this.object = object;
        this.typeNames = new ArrayList<String>(typeNames);
        this.methods = Callbacks.collectMethods(object);
        this.className = object.getClass().getSimpleName();
        if (object instanceof NamedDevice) {
            NamedDevice namedDevice = (NamedDevice)object;
            this.typeNames.addAll(namedDevice.getDeviceTypeNames());
        }
        if (this.typeNames.isEmpty()) {
            this.typeNames.add(ObjectDevice.toNiceTypeName(object.getClass()));
        }
    }

    public ObjectDevice(Object object, String ... typeNames) {
        this(object, Arrays.asList(typeNames));
    }

    public ObjectDevice(Object object, @Nullable String typeName) {
        this(object, typeName != null ? Collections.singletonList(typeName) : Collections.emptyList());
    }

    public ObjectDevice(Object object) {
        this(object, Collections.emptyList());
    }

    public RPCEventSource asEventSource() {
        Object object = this.object;
        if (object instanceof RPCEventSource) {
            RPCEventSource res = (RPCEventSource)object;
            return res;
        }
        return null;
    }

    @Override
    public List<String> getTypeNames() {
        return this.typeNames;
    }

    @Override
    public List<RPCMethodGroup> getMethodGroups() {
        return this.methods;
    }

    @Override
    public void mount() {
        Object object = this.object;
        if (object instanceof LifecycleAwareDevice) {
            LifecycleAwareDevice device = (LifecycleAwareDevice)object;
            device.onDeviceMounted();
        }
    }

    @Override
    public void unmount() {
        Object object = this.object;
        if (object instanceof LifecycleAwareDevice) {
            LifecycleAwareDevice device = (LifecycleAwareDevice)object;
            device.onDeviceUnmounted();
        }
    }

    @Override
    public void dispose() {
        Object object = this.object;
        if (object instanceof LifecycleAwareDevice) {
            LifecycleAwareDevice device = (LifecycleAwareDevice)object;
            device.onDeviceDisposed();
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectDevice that = (ObjectDevice)o;
        return this.object.equals(that.object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public String toString() {
        return this.className;
    }

    private static String toNiceTypeName(Class<?> deviceClass) {
        String name = deviceClass.getSimpleName().replaceFirst("VMDevice$", "").replaceFirst("RPCDevice$", "").replaceFirst("Device$", "");
        return name.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.ROOT);
    }
}

