/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import com.google.gson.internal.LinkedTreeMap;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.DocumentedDevice;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.LazyOptionalUtils;
import li.cil.oc2.common.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public final class NetworkSwitchBlockEntity
extends ModBlockEntity
implements NamedDevice,
DocumentedDevice,
NetworkInterface,
TickableBlockEntity {
    private final String GET_LINK_STATE = "getLinkState";
    private final String GET_HOST_TABLE = "getHostTable";
    private final String GET_PORT_CONFIG = "getPortConfig";
    private final String SET_PORT_CONFIG = "setPortConfig";
    private final long HOST_TTL = 2400L;
    private final int TTL_COST = 1;
    private final Map<Long, HostEntry> hostTable = new HashMap<Long, HostEntry>();
    private final PortSettings[] portSettings = new PortSettings[Constants.BLOCK_FACE_COUNT];
    private int tickCount = 0;
    private final NetworkInterface[] adjacentBlockInterfaces = new NetworkInterface[Constants.BLOCK_FACE_COUNT];
    private boolean haveAdjacentBlocksChanged = true;

    public NetworkSwitchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.NETWORK_SWITCH.get(), pos, state);
        for (int i = 0; i < this.portSettings.length; ++i) {
            this.portSettings[i] = new PortSettings();
        }
    }

    @Override
    public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        this.validateAdjacentBlocks();
        long tickTime = this.m_58904_().m_46467_();
        long destMac = this.macToLong(frame, 0);
        long srcMac = this.macToLong(frame, 6);
        short vlan = this.getVLAN(frame);
        Optional<Integer> optSide = this.sideReverseLookup(source);
        if (!optSide.isPresent()) {
            return;
        }
        int side = optSide.get();
        if (this.hostTable.size() <= 256) {
            this.hostTable.put(srcMac, new HostEntry(side, tickTime));
        }
        PortSettings ingressSettings = this.portSettings[side];
        SwitchLog log = new SwitchLog(vlan, side, srcMac, destMac);
        if (vlan == 0) {
            Pair<Short, byte[]> pair = this.removeVLANTag(frame);
            frame = (byte[])pair.getSecond();
            if (ingressSettings.untagged != 0) {
                frame = this.addVLANTag(frame, ingressSettings.untagged);
                vlan = ingressSettings.untagged;
            }
        } else if (!ingressSettings.trunkAll && !ingressSettings.tagged.contains(vlan)) {
            log.drop("Tag not allowed for ingress");
            return;
        }
        HostEntry host = this.hostTable.get(destMac);
        if (host != null) {
            if (host.iface == side && !ingressSettings.hairpin) {
                log.drop("hairpin disabled");
                return;
            }
            this.writeToSide(frame, host.iface, vlan, log, timeToLive);
        } else {
            log.flood();
            for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
                if (i == side) continue;
                this.writeToSide(frame, i, vlan, log, timeToLive);
            }
        }
    }

    @Override
    public byte[] readEthernetFrame() {
        return null;
    }

    private void writeToSide(byte[] frame, int side, short vlan, SwitchLog log, int timeToLive) {
        log.egressPort(side);
        NetworkInterface iface = this.adjacentBlockInterfaces[side];
        if (iface != null) {
            PortSettings egressSettings = this.portSettings[side];
            if (egressSettings.untagged != 0 && vlan == 0) {
                log.drop("inner tag untagged");
                return;
            }
            if (egressSettings.untagged == vlan) {
                Pair<Short, byte[]> pair = this.removeVLANTag(frame);
                frame = (byte[])pair.getSecond();
                log.egressVlan = 0;
            } else {
                if (!egressSettings.trunkAll && !egressSettings.tagged.contains(vlan)) {
                    log.drop("Tag not allowed for egress");
                    return;
                }
                log.egressVlan = vlan;
            }
            log.emit();
            iface.writeEthernetFrame(this, frame, timeToLive - 1);
        }
    }

    private long macToLong(byte[] mac, int offset) {
        long ret = 0L;
        for (int i = 0; i < 6; ++i) {
            ret |= ((long)mac[i + offset] & 0xFFL) << i * 8;
        }
        return ret;
    }

    @Override
    public void clientTick() {
    }

    @Override
    public void serverTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.tickCount++ % 20 == 0) {
            long threshold = this.m_58904_().m_46467_() - 2400L;
            if (threshold < 0L) {
                return;
            }
            this.hostTable.entrySet().removeIf(e -> ((HostEntry)e.getValue()).timestamp < threshold);
        }
    }

    @Override
    public void getDeviceDocumentation(DocumentedDevice.DeviceVisitor visitor) {
        visitor.visitCallback("getHostTable").description("Returns the MAC address table of the switch").returnValueDescription("The MAC table. For each host the mac address, the age (in ticks) and the face is returned");
    }

    @Override
    public Collection<String> getDeviceTypeNames() {
        return Collections.singletonList("switch");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag hosts = new ListTag();
        for (Map.Entry<Long, HostEntry> host : this.hostTable.entrySet()) {
            CompoundTag thisHost = new CompoundTag();
            thisHost.m_128365_("mac", (Tag)LongTag.m_128882_((long)host.getKey()));
            thisHost.m_128365_("side", (Tag)IntTag.m_128679_((int)host.getValue().iface));
            thisHost.m_128365_("timestamp", (Tag)LongTag.m_128882_((long)host.getValue().timestamp));
            hosts.add((Object)thisHost);
        }
        tag.m_128365_("hosts", (Tag)hosts);
        ListTag ports = new ListTag();
        for (PortSettings myPort : this.portSettings) {
            CompoundTag port = new CompoundTag();
            myPort.save(port);
            ports.add((Object)port);
        }
        tag.m_128365_("ports", (Tag)ports);
    }

    public void m_142466_(CompoundTag tag) {
        Tag ports;
        super.m_142466_(tag);
        Tag hosts = tag.m_128423_("hosts");
        if (hosts != null) {
            for (Tag host_ : (ListTag)hosts) {
                CompoundTag host = (CompoundTag)host_;
                this.hostTable.put(host.m_128454_("mac"), new HostEntry(tag.m_128451_("side"), tag.m_128454_("timestamp")));
            }
        }
        if ((ports = tag.m_128423_("ports")) != null) {
            int i = 0;
            for (Tag port : (ListTag)ports) {
                this.portSettings[i++] = PortSettings.load((CompoundTag)port);
            }
        }
    }

    @Callback(name="getHostTable")
    public List<LuaHostEntry> getHostTable() {
        long now = this.m_58904_().m_46467_();
        return this.hostTable.entrySet().stream().map(e -> new LuaHostEntry(NetworkSwitchBlockEntity.macLongToString((Long)e.getKey()), now - ((HostEntry)e.getValue()).timestamp, ((HostEntry)e.getValue()).iface)).collect(Collectors.toList());
    }

    @Callback(name="getPortConfig", synchronize=false)
    public PortSettings[] getPortSettings() {
        return this.portSettings;
    }

    @Callback(name="setPortConfig")
    public void setPortSettings(List<LinkedTreeMap> settings) {
        int max = Math.min(this.portSettings.length, settings.size());
        for (int i = 0; i < max; ++i) {
            this.portSettings[i].untagged = ((Double)settings.get(i).get((Object)"untagged")).shortValue();
        }
    }

    @Callback(name="getLinkState")
    public boolean[] getLinkState() {
        this.validateAdjacentBlocks();
        boolean[] sides = new boolean[Constants.BLOCK_FACE_COUNT];
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            sides[i] = this.adjacentBlockInterfaces[i] != null;
        }
        return sides;
    }

    private Optional<Integer> sideReverseLookup(NetworkInterface iface) {
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            if (iface != this.adjacentBlockInterfaces[i]) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private static String macLongToString(long mac) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if (i != 0) {
                ret.append(":");
            }
            ret.append(String.format("%02x", mac >> i * 8 & 0xFFL));
        }
        return ret.toString();
    }

    private byte[] addVLANTag(byte[] packet, short tag) {
        if (tag != 0) {
            byte[] ret = new byte[packet.length + 4];
            this.copyBytes(packet, ret, 0, 0, 12);
            this.copyBytes(packet, ret, 12, 16, packet.length - 12);
            ret[12] = -127;
            ret[13] = 0;
            ret[14] = (byte)(tag >> 8 & 0xF);
            ret[15] = (byte)(tag & 0xFF);
            return ret;
        }
        return packet;
    }

    private short getVLAN(byte[] packet) {
        if (packet[12] == -127 && packet[13] == 0) {
            return (short)(packet[15] | ((short)packet[14] & 0xF) << 8);
        }
        return 0;
    }

    private Pair<Short, byte[]> removeVLANTag(byte[] packet) {
        if (packet[12] == -127 && packet[13] == 0) {
            byte[] ret = new byte[packet.length - 4];
            this.copyBytes(packet, ret, 0, 0, 12);
            this.copyBytes(packet, ret, 16, 12, packet.length - 16);
            short tag = (short)(packet[15] | ((short)packet[14] & 0xF) << 8);
            return new Pair((Object)tag, (Object)ret);
        }
        return new Pair((Object)0, (Object)packet);
    }

    private void copyBytes(byte[] input, byte[] output, int inputOffset, int outputOffset, int length) {
        if (length >= 0) {
            System.arraycopy(input, inputOffset, output, outputOffset, length);
        }
    }

    private void validateAdjacentBlocks() {
        if (this.m_58901_() || !this.haveAdjacentBlocksChanged) {
            return;
        }
        for (Direction side : Constants.DIRECTIONS) {
            this.adjacentBlockInterfaces[side.m_122411_()] = null;
        }
        this.haveAdjacentBlocksChanged = false;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos pos = this.m_58899_();
        for (Direction side : Constants.DIRECTIONS) {
            BlockEntity neighborBlockEntity = LevelUtils.getBlockEntityIfChunkExists((LevelAccessor)this.f_58857_, pos.m_121945_(side));
            if (neighborBlockEntity == null) continue;
            LazyOptional optional = neighborBlockEntity.getCapability(Capabilities.networkInterface(), side.m_122424_());
            optional.ifPresent(adjacentInterface -> {
                this.adjacentBlockInterfaces[side.m_122411_()] = adjacentInterface;
                LazyOptionalUtils.addWeakListener(optional, this, (hub, unused) -> hub.handleNeighborChanged());
            });
        }
    }

    private void handleNeighborChanged() {
        this.haveAdjacentBlocksChanged = true;
    }

    private static class PortSettings {
        public short untagged;
        public final List<Short> tagged;
        public final boolean hairpin;
        public final boolean trunkAll;

        public PortSettings(short untagged, List<Short> tagged, boolean hairpin, boolean trunkAll) {
            this.untagged = untagged;
            this.tagged = tagged;
            this.hairpin = hairpin;
            this.trunkAll = trunkAll;
        }

        public PortSettings() {
            this(0, Collections.emptyList(), false, true);
        }

        public void save(CompoundTag tag) {
            tag.m_128365_("untagged", (Tag)ShortTag.m_129258_((short)this.untagged));
            tag.m_128365_("tagged", (Tag)new IntArrayTag(this.tagged.stream().map(s -> (int)s).collect(Collectors.toList())));
            tag.m_128365_("hairpin", (Tag)ByteTag.m_128273_((boolean)this.hairpin));
            tag.m_128365_("trunkAll", (Tag)ByteTag.m_128273_((boolean)this.trunkAll));
        }

        public static PortSettings load(CompoundTag tag) {
            short untagged = tag.m_128448_("untagged");
            List<Short> tagged = Arrays.stream(tag.m_128465_("tagged")).mapToObj(i -> (short)i).collect(Collectors.toList());
            boolean hairpin = tag.m_128471_("hairpin");
            boolean trunkAll = tag.m_128471_("trunkAll");
            return new PortSettings(untagged, tagged, hairpin, trunkAll);
        }
    }

    private static class HostEntry {
        public final int iface;
        public final long timestamp;

        public HostEntry(int iface, long timestamp) {
            this.iface = iface;
            this.timestamp = timestamp;
        }
    }

    private static class SwitchLog {
        private static final boolean ENABLED = true;
        private short ingressVlan = 0;
        private short egressVlan = 0;
        private int ingressSide = 0;
        private final long srcMac;
        private final long destMac;
        private Integer egressSide = null;

        public SwitchLog(short ingressVlan, int ingressSide, long srcMac, long destMac) {
            this.ingressVlan = ingressVlan;
            this.ingressSide = ingressSide;
            this.srcMac = srcMac;
            this.destMac = destMac;
        }

        public void egressPort(int side) {
            this.egressSide = side;
        }

        public void drop(String reason) {
            String inMac = NetworkSwitchBlockEntity.macLongToString(this.srcMac);
            String outMac = NetworkSwitchBlockEntity.macLongToString(this.destMac);
            if (this.egressSide == null) {
                System.out.printf("Switch Packet %s (Port %s, VLAN %s) -> %s drop (%s)\n", inMac, this.ingressSide, this.ingressVlan, outMac, reason);
            } else {
                System.out.printf("Switch Packet %s (Port %s, VLAN %s) -> %s (Port %s) drop (%s)\n", inMac, this.ingressSide, this.ingressVlan, outMac, this.egressSide, reason);
            }
        }

        public void emit() {
            String inMac = NetworkSwitchBlockEntity.macLongToString(this.srcMac);
            String outMac = NetworkSwitchBlockEntity.macLongToString(this.destMac);
            System.out.printf("Switch Packet %s (Port %s, VLAN %s) -> %s (Port %s, VLAN %s)\n", inMac, this.ingressSide, this.ingressVlan, outMac, this.egressSide, this.egressVlan);
        }

        public void flood() {
            String inMac = NetworkSwitchBlockEntity.macLongToString(this.srcMac);
            String outMac = NetworkSwitchBlockEntity.macLongToString(this.destMac);
            System.out.printf("Switch Packet %s (Port %s, VLAN %s) -> %s flood\n", inMac, this.ingressSide, this.ingressVlan, outMac);
        }
    }

    public static class LuaHostEntry {
        public final String mac;
        public final long age;
        public final int side;

        public LuaHostEntry(String mac, long age, int iface) {
            this.mac = mac;
            this.age = age;
            this.side = iface;
        }
    }
}

