/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.BlockDeviceProvider;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.util.Invalidatable;
import li.cil.oc2.common.bus.device.DeviceGroup;
import li.cil.oc2.common.bus.device.provider.Providers;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.bus.device.util.ItemDeviceInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.IForgeRegistry;

public final class Devices {
    public static BlockDeviceQuery makeQuery(BlockEntity blockEntity, @Nullable Direction side) {
        Level level = Objects.requireNonNull(blockEntity.m_58904_());
        BlockPos pos = blockEntity.m_58899_();
        return new BlockQuery((LevelAccessor)level, pos, side);
    }

    public static BlockDeviceQuery makeQuery(LevelAccessor level, BlockPos pos, @Nullable Direction side) {
        return new BlockQuery(level, pos, side);
    }

    public static ItemDeviceQuery makeQuery(ItemStack stack) {
        return new ItemQuery(stack);
    }

    public static ItemDeviceQuery makeQuery(BlockEntity blockEntity, ItemStack stack) {
        return new ItemQuery(blockEntity, stack);
    }

    public static ItemDeviceQuery makeQuery(Entity entity, ItemStack stack) {
        return new ItemQuery(entity, stack);
    }

    public static Optional<List<Invalidatable<BlockDeviceInfo>>> getDevices(BlockDeviceQuery query) {
        ChunkPos queryChunk = new ChunkPos(query.getQueryPosition());
        if (!query.getLevel().m_7232_(queryChunk.f_45578_, queryChunk.f_45579_)) {
            return Optional.empty();
        }
        IForgeRegistry<BlockDeviceProvider> registry = Providers.blockDeviceProviderRegistry();
        ArrayList<Invalidatable<BlockDeviceInfo>> devices = new ArrayList<Invalidatable<BlockDeviceInfo>>();
        for (BlockDeviceProvider provider : registry.getValues()) {
            Invalidatable<Device> device = provider.getDevice(query);
            if (!device.isPresent()) continue;
            Device device2 = device.get();
            if (device2 instanceof DeviceGroup) {
                DeviceGroup group = (DeviceGroup)device2;
                for (Device dev : group.getDevices()) {
                    Invalidatable<Device> de = Invalidatable.of(dev);
                    devices.add(de.mapWithDependency(d -> new BlockDeviceInfo(provider, (Device)d)));
                }
                continue;
            }
            devices.add(device.mapWithDependency(d -> new BlockDeviceInfo(provider, (Device)d)));
        }
        return Optional.of(devices);
    }

    public static List<ItemDeviceInfo> getDevices(ItemDeviceQuery query) {
        if (query.getItemStack().m_41619_()) {
            return Collections.emptyList();
        }
        IForgeRegistry<ItemDeviceProvider> registry = Providers.itemDeviceProviderRegistry();
        ArrayList<ItemDeviceInfo> devices = new ArrayList<ItemDeviceInfo>();
        for (ItemDeviceProvider provider : registry.getValues()) {
            Optional<ItemDevice> device = provider.getDevice(query);
            device.ifPresent(d -> devices.add(new ItemDeviceInfo(provider, (ItemDevice)d, provider.getEnergyConsumption(query))));
        }
        return devices;
    }

    public static int getEnergyConsumption(ItemDeviceQuery query) {
        if (query.getItemStack().m_41619_()) {
            return 0;
        }
        IForgeRegistry<ItemDeviceProvider> registry = Providers.itemDeviceProviderRegistry();
        long accumulator = 0L;
        for (ItemDeviceProvider provider : registry.getValues()) {
            accumulator += (long)Math.max(0, provider.getEnergyConsumption(query));
        }
        if (accumulator > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)accumulator;
    }

    private record BlockQuery(LevelAccessor level, BlockPos pos, @Nullable Direction side) implements BlockDeviceQuery
    {
        @Override
        public LevelAccessor getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getQueryPosition() {
            return this.pos;
        }

        @Override
        @Nullable
        public Direction getQuerySide() {
            return this.side;
        }
    }

    private record ItemQuery(@Nullable BlockEntity blockEntity, @Nullable Entity entity, ItemStack stack) implements ItemDeviceQuery
    {
        public ItemQuery(ItemStack stack) {
            this(null, null, stack);
        }

        public ItemQuery(BlockEntity blockEntity, ItemStack stack) {
            this(blockEntity, null, stack);
        }

        public ItemQuery(Entity entity, ItemStack stack) {
            this(null, entity, stack);
        }

        @Override
        public Optional<BlockEntity> getContainerBlockEntity() {
            return Optional.ofNullable(this.blockEntity);
        }

        @Override
        public Optional<Entity> getContainerEntity() {
            return Optional.ofNullable(this.entity);
        }

        @Override
        public ItemStack getItemStack() {
            return this.stack;
        }
    }
}

