/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.config.common;

import li.cil.oc2.common.config.common.AdminSpec;
import li.cil.oc2.common.config.common.EnergySpec;
import li.cil.oc2.common.config.common.GameplaySpec;
import li.cil.oc2.common.config.common.InternetCardSpec;
import li.cil.oc2.common.config.common.VMSpec;
import li.cil.oc2.common.config.common.VXLANSpec;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonSpec {
    public static final ForgeConfigSpec CONFIG_SPEC;
    private static final VMSpec vmSpec;
    private static final EnergySpec energySpec;
    private static final GameplaySpec gameplaySpec;
    private static final AdminSpec adminSpec;
    private static final VXLANSpec vxlanSpec;
    private static final InternetCardSpec internetCardSpec;

    public static void loadValues() {
        vmSpec.loadValues();
        energySpec.loadValues();
        gameplaySpec.loadValues();
        adminSpec.loadValues();
        vxlanSpec.loadValues();
        internetCardSpec.loadValues();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("vm");
        vmSpec = new VMSpec(builder);
        builder.pop();
        builder.push("energy");
        energySpec = new EnergySpec(builder);
        builder.pop();
        builder.push("gameplay");
        gameplaySpec = new GameplaySpec(builder);
        builder.pop();
        builder.push("admin");
        adminSpec = new AdminSpec(builder);
        builder.pop();
        builder.push("vxlan");
        vxlanSpec = new VXLANSpec(builder);
        builder.pop();
        builder.push("internet_card");
        internetCardSpec = new InternetCardSpec(builder);
        builder.pop();
        CONFIG_SPEC = builder.build();
    }
}

