/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.util.Objects;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.inet.SessionBase;
import li.cil.oc2.common.inet.SessionDiscriminator;

public abstract class SocketSessionDiscriminator<S extends SessionBase>
implements SessionDiscriminator<S> {
    private final int srcIpAddress;
    private final short srcPort;
    private final int dstIpAddress;
    private final short dstPort;

    public SocketSessionDiscriminator(int srcIpAddress, short srcPort, int dstIpAddress, short dstPort) {
        this.srcIpAddress = srcIpAddress;
        this.srcPort = srcPort;
        this.dstIpAddress = dstIpAddress;
        this.dstPort = dstPort;
    }

    public int getSrcIpAddress() {
        return this.srcIpAddress;
    }

    public short getSrcPort() {
        return this.srcPort;
    }

    public int getDstIpAddress() {
        return this.dstIpAddress;
    }

    public short getDstPort() {
        return this.dstPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketSessionDiscriminator that = (SocketSessionDiscriminator)o;
        return this.srcIpAddress == that.srcIpAddress && this.srcPort == that.srcPort && this.dstIpAddress == that.dstIpAddress && this.dstPort == that.dstPort;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.srcIpAddress, this.srcPort, this.dstIpAddress, this.dstPort);
    }

    abstract String protocolName();

    public String toString() {
        StringBuilder builder = new StringBuilder(this.protocolName());
        builder.append('(');
        InetUtils.socketAddressToString(builder, this.srcIpAddress, this.srcPort);
        builder.append("<->");
        InetUtils.socketAddressToString(builder, this.dstIpAddress, this.dstPort);
        builder.append(')');
        return builder.toString();
    }
}

