/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.global;

import java.util.BitSet;
import java.util.OptionalInt;
import li.cil.oc2.api.bus.device.vm.context.InterruptAllocator;
import li.cil.oc2.common.vm.context.InterruptManager;
import li.cil.oc2.common.vm.context.InterruptValidator;

final class GlobalInterruptAllocator
implements InterruptAllocator,
InterruptValidator,
InterruptManager {
    private final BitSet claimedInterrupts = new BitSet();
    private final BitSet reservedInterrupts;
    private final int interruptCount;
    private int managedMask;

    public GlobalInterruptAllocator(int interruptCount, BitSet reservedInterrupts) {
        this.reservedInterrupts = reservedInterrupts;
        this.interruptCount = interruptCount;
        this.claimedInterrupts.set(0);
    }

    public BitSet getClaimedInterrupts() {
        return this.claimedInterrupts;
    }

    @Override
    public boolean claimInterrupt(int interrupt) {
        if (interrupt < 1 || interrupt >= this.interruptCount) {
            throw new IllegalArgumentException();
        }
        if (this.claimedInterrupts.get(interrupt)) {
            return false;
        }
        this.claimedInterrupts.set(interrupt);
        this.managedMask |= 1 << interrupt;
        return true;
    }

    @Override
    public OptionalInt claimInterrupt() {
        BitSet allClaimedInterrupts = new BitSet();
        allClaimedInterrupts.or(this.claimedInterrupts);
        allClaimedInterrupts.or(this.reservedInterrupts);
        int interrupt = allClaimedInterrupts.nextClearBit(0);
        if (interrupt >= this.interruptCount) {
            return OptionalInt.empty();
        }
        this.claimedInterrupts.set(interrupt);
        this.managedMask |= 1 << interrupt;
        return OptionalInt.of(interrupt);
    }

    @Override
    public boolean isMaskValid(int mask) {
        return (mask & ~this.managedMask) == 0;
    }

    @Override
    public int getMaskedInterrupts(int interrupts) {
        return interrupts & this.managedMask;
    }

    @Override
    public int getInterruptCount() {
        return this.interruptCount;
    }

    @Override
    public void releaseInterrupts(BitSet interrupts) {
        this.claimedInterrupts.andNot(interrupts);
        int interrupt = interrupts.nextSetBit(0);
        while (interrupt >= 0) {
            this.managedMask &= ~(1 << interrupt);
            interrupt = interrupts.nextSetBit(interrupt + 1);
        }
    }
}

