/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.data;

import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.item.Items;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlockStateProvider
extends BlockStateProvider {
    private static final ResourceLocation CABLE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/cable_base");
    private static final ResourceLocation CABLE_LINK_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/cable_link");
    private static final ResourceLocation CABLE_PLUG_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/cable_plug");
    private static final ResourceLocation CABLE_STRAIGHT_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/cable_straight");
    private static final ResourceLocation CHARGER_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/charger");
    private static final ResourceLocation COMPUTER_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/computer");
    private static final ResourceLocation MONITOR_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/monitor");
    private static final ResourceLocation DISK_DRIVE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/disk_drive");
    private static final ResourceLocation KEYBOARD_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/keyboard");
    private static final ResourceLocation NETWORK_CONNECTOR_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/network_connector");
    private static final ResourceLocation NETWORK_HUB_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/network_hub");
    private static final ResourceLocation PROJECTOR_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/projector");
    private static final ResourceLocation REDSTONE_INTERFACE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/redstone_interface");

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "oc2r", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock(Blocks.CHARGER, Items.CHARGER, CHARGER_MODEL);
        this.horizontalBlock(Blocks.COMPUTER, Items.COMPUTER, COMPUTER_MODEL);
        this.horizontalBlock(Blocks.MONITOR, Items.MONITOR, MONITOR_MODEL);
        this.simpleBlock(Blocks.CREATIVE_ENERGY, Items.CREATIVE_ENERGY);
        this.horizontalBlock(Blocks.DISK_DRIVE, Items.DISK_DRIVE, DISK_DRIVE_MODEL);
        this.horizontalBlock(Blocks.KEYBOARD, Items.KEYBOARD, KEYBOARD_MODEL);
        this.horizontalFaceBlock(Blocks.NETWORK_CONNECTOR, Items.NETWORK_CONNECTOR, NETWORK_CONNECTOR_MODEL).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 315.0f, 0.0f).translation(0.0f, 2.0f, 0.0f).scale(0.75f, 0.75f, 0.75f).end().transform(ItemDisplayContext.FIXED).rotation(270.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -5.0f).scale(1.0f, 1.0f, 1.0f).end().end();
        this.horizontalBlock(Blocks.NETWORK_HUB, Items.NETWORK_HUB, NETWORK_HUB_MODEL);
        this.horizontalBlock(Blocks.PROJECTOR, Items.PROJECTOR, PROJECTOR_MODEL);
        this.horizontalBlock(Blocks.REDSTONE_INTERFACE, Items.REDSTONE_INTERFACE, REDSTONE_INTERFACE_MODEL);
        this.registerCableStates();
    }

    private void registerCableStates() {
        ModelFile.ExistingModelFile baseModel = this.models().getExistingFile(CABLE_MODEL);
        ModelFile.ExistingModelFile linkModel = this.models().getExistingFile(CABLE_LINK_MODEL);
        ModelFile.ExistingModelFile plugModel = this.models().getExistingFile(CABLE_PLUG_MODEL);
        ModelFile.ExistingModelFile straightModel = this.models().getExistingFile(CABLE_STRAIGHT_MODEL);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)Blocks.BUS_CABLE.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)baseModel).addModel()).end();
        BusCableBlock.FACING_TO_CONNECTION_MAP.forEach((arg_0, arg_1) -> ModBlockStateProvider.lambda$registerCableStates$0(builder, (ModelFile)linkModel, (ModelFile)plugModel, arg_0, arg_1));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(Items.BUS_CABLE.getId().m_135815_())).parent((ModelFile)straightModel)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).scale(0.75f).end().transform(ItemDisplayContext.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.75f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.75f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).scale(0.75f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.75f).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(Items.BUS_INTERFACE.getId().m_135815_())).parent((ModelFile)plugModel)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 315.0f, 0.0f).translation(2.0f, 1.0f, 0.0f).scale(0.75f).end().transform(ItemDisplayContext.GROUND).translation(0.0f, 3.0f, -5.0f).scale(0.75f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 4.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 180.0f, 0.0f).translation(0.0f, -1.0f, 0.0f).scale(0.75f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 2.0f).scale(0.75f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 2.0f).scale(0.75f).end();
    }

    private <T extends Block> ItemModelBuilder horizontalBlock(RegistryObject<T> block, RegistryObject<Item> item, ResourceLocation modelFileLocation) {
        this.horizontalBlock((Block)block.get(), (ModelFile)this.models().getExistingFile(modelFileLocation));
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.getId().m_135815_())).parent((ModelFile)this.models().getExistingFile(block.getId()));
    }

    private <T extends Block> ItemModelBuilder horizontalFaceBlock(RegistryObject<T> block, RegistryObject<Item> item, ResourceLocation modelFileLocation) {
        this.horizontalFaceBlock((Block)block.get(), (ModelFile)this.models().getExistingFile(modelFileLocation));
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.getId().m_135815_())).parent((ModelFile)this.models().getExistingFile(block.getId()));
    }

    private <T extends Block> void simpleBlock(RegistryObject<T> block, RegistryObject<Item> item) {
        this.simpleBlock((Block)block.get());
        ((ItemModelBuilder)this.itemModels().getBuilder(item.getId().m_135815_())).parent((ModelFile)this.models().getExistingFile(block.getId()));
    }

    private static /* synthetic */ void lambda$registerCableStates$0(MultiPartBlockStateBuilder builder, ModelFile linkModel, ModelFile plugModel, Direction direction, EnumProperty connectionType) {
        int rotationY = (int)direction.m_122435_();
        int rotationX = direction == Direction.UP ? 90 : (direction == Direction.DOWN ? -90 : 0);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(linkModel).rotationY(rotationY).rotationX(rotationX).addModel()).condition((Property)connectionType, (Comparable[])new BusCableBlock.ConnectionType[]{BusCableBlock.ConnectionType.CABLE}).condition((Property)BusCableBlock.HAS_FACADE, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(plugModel).rotationY(rotationY).rotationX(rotationX).addModel()).condition((Property)connectionType, (Comparable[])new BusCableBlock.ConnectionType[]{BusCableBlock.ConnectionType.INTERFACE}).condition((Property)BusCableBlock.HAS_FACADE, (Comparable[])new Boolean[]{false}).end();
    }
}

