/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264;

import li.cil.oc2.jcodec.codecs.h264.io.model.NALUnit;
import li.cil.oc2.jcodec.codecs.h264.io.model.NALUnitType;
import li.cil.oc2.jcodec.codecs.h264.io.model.RefPicMarking;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceHeader;

public final class POCManager {
    private int prevPOCMsb;
    private int prevPOCLsb;

    public int calcPOC(SliceHeader firstSliceHeader, NALUnit firstNu) {
        return switch (firstSliceHeader.sps.picOrderCntType) {
            case 0 -> this.calcPOC0(firstSliceHeader, firstNu);
            case 1 -> this.calcPOC1(firstSliceHeader);
            case 2 -> this.calcPOC2(firstSliceHeader);
            default -> throw new RuntimeException("Invalid POC");
        };
    }

    private int calcPOC2(SliceHeader firstSliceHeader) {
        return firstSliceHeader.frameNum << 1;
    }

    private int calcPOC1(SliceHeader firstSliceHeader) {
        return firstSliceHeader.frameNum << 1;
    }

    private int calcPOC0(SliceHeader firstSliceHeader, NALUnit firstNu) {
        if (firstNu.type == NALUnitType.IDR_SLICE) {
            this.prevPOCLsb = 0;
            this.prevPOCMsb = 0;
        }
        int maxPOCLsbDiv2 = 1 << firstSliceHeader.sps.log2MaxPicOrderCntLsbMinus4 + 3;
        int maxPOCLsb = maxPOCLsbDiv2 << 1;
        int POCLsb = firstSliceHeader.picOrderCntLsb;
        int POCMsb = POCLsb < this.prevPOCLsb && this.prevPOCLsb - POCLsb >= maxPOCLsbDiv2 ? this.prevPOCMsb + maxPOCLsb : (POCLsb > this.prevPOCLsb && POCLsb - this.prevPOCLsb > maxPOCLsbDiv2 ? this.prevPOCMsb - maxPOCLsb : this.prevPOCMsb);
        int POC = POCMsb + POCLsb;
        if (firstNu.nal_ref_idc > 0) {
            if (this.hasMMCO5(firstSliceHeader, firstNu)) {
                this.prevPOCMsb = 0;
                this.prevPOCLsb = POC;
            } else {
                this.prevPOCMsb = POCMsb;
                this.prevPOCLsb = POCLsb;
            }
        }
        return POC;
    }

    private boolean hasMMCO5(SliceHeader firstSliceHeader, NALUnit firstNu) {
        if (firstNu.type != NALUnitType.IDR_SLICE && firstSliceHeader.refPicMarkingNonIDR != null) {
            RefPicMarking.Instruction[] instructions;
            for (RefPicMarking.Instruction instruction : instructions = firstSliceHeader.refPicMarkingNonIDR.instructions()) {
                if (instruction.type() != RefPicMarking.InstrType.CLEAR) continue;
                return true;
            }
        }
        return false;
    }
}

