/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.io.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import li.cil.oc2.jcodec.codecs.h264.decode.CAVLCReader;
import li.cil.oc2.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2.jcodec.codecs.h264.io.write.CAVLCWriter;
import li.cil.oc2.jcodec.common.io.BitReader;
import li.cil.oc2.jcodec.common.io.BitWriter;

public final class PictureParameterSet {
    public boolean entropyCodingModeFlag;
    public int[] numRefIdxActiveMinus1 = new int[2];
    public int sliceGroupChangeRateMinus1;
    public int picParameterSetId;
    public int seqParameterSetId;
    public boolean picOrderPresentFlag;
    public int numSliceGroupsMinus1;
    public int sliceGroupMapType;
    public boolean weightedPredFlag;
    public int weightedBipredIdc;
    public int picInitQpMinus26;
    public int picInitQsMinus26;
    public int chromaQpIndexOffset;
    public boolean deblockingFilterControlPresentFlag;
    public boolean constrainedIntraPredFlag;
    public boolean redundantPicCntPresentFlag;
    public int[] topLeft;
    public int[] bottomRight;
    public int[] runLengthMinus1;
    public boolean sliceGroupChangeDirectionFlag;
    public int[] sliceGroupId;
    public PPSExt extended;

    public static PictureParameterSet read(ByteBuffer is) {
        BitReader _in = BitReader.createBitReader(is);
        PictureParameterSet pps = new PictureParameterSet();
        pps.picParameterSetId = CAVLCReader.readUE(_in);
        pps.seqParameterSetId = CAVLCReader.readUE(_in);
        pps.entropyCodingModeFlag = CAVLCReader.readBool(_in);
        pps.picOrderPresentFlag = CAVLCReader.readBool(_in);
        pps.numSliceGroupsMinus1 = CAVLCReader.readUE(_in);
        if (pps.numSliceGroupsMinus1 > 0) {
            pps.sliceGroupMapType = CAVLCReader.readUE(_in);
            pps.topLeft = new int[pps.numSliceGroupsMinus1 + 1];
            pps.bottomRight = new int[pps.numSliceGroupsMinus1 + 1];
            pps.runLengthMinus1 = new int[pps.numSliceGroupsMinus1 + 1];
            if (pps.sliceGroupMapType == 0) {
                for (iGroup = 0; iGroup <= pps.numSliceGroupsMinus1; ++iGroup) {
                    pps.runLengthMinus1[iGroup] = CAVLCReader.readUE(_in);
                }
            } else if (pps.sliceGroupMapType == 2) {
                for (iGroup = 0; iGroup < pps.numSliceGroupsMinus1; ++iGroup) {
                    pps.topLeft[iGroup] = CAVLCReader.readUE(_in);
                    pps.bottomRight[iGroup] = CAVLCReader.readUE(_in);
                }
            } else if (pps.sliceGroupMapType == 3 || pps.sliceGroupMapType == 4 || pps.sliceGroupMapType == 5) {
                pps.sliceGroupChangeDirectionFlag = CAVLCReader.readBool(_in);
                pps.sliceGroupChangeRateMinus1 = CAVLCReader.readUE(_in);
            } else if (pps.sliceGroupMapType == 6) {
                int NumberBitsPerSliceGroupId = pps.numSliceGroupsMinus1 + 1 > 4 ? 3 : (pps.numSliceGroupsMinus1 + 1 > 2 ? 2 : 1);
                int pic_size_in_map_units_minus1 = CAVLCReader.readUE(_in);
                pps.sliceGroupId = new int[pic_size_in_map_units_minus1 + 1];
                for (int i = 0; i <= pic_size_in_map_units_minus1; ++i) {
                    pps.sliceGroupId[i] = CAVLCReader.readU(_in, NumberBitsPerSliceGroupId);
                }
            }
        }
        pps.numRefIdxActiveMinus1 = new int[]{CAVLCReader.readUE(_in), CAVLCReader.readUE(_in)};
        pps.weightedPredFlag = CAVLCReader.readBool(_in);
        pps.weightedBipredIdc = CAVLCReader.readNBit(_in, 2);
        pps.picInitQpMinus26 = CAVLCReader.readSE(_in);
        pps.picInitQsMinus26 = CAVLCReader.readSE(_in);
        pps.chromaQpIndexOffset = CAVLCReader.readSE(_in);
        pps.deblockingFilterControlPresentFlag = CAVLCReader.readBool(_in);
        pps.constrainedIntraPredFlag = CAVLCReader.readBool(_in);
        pps.redundantPicCntPresentFlag = CAVLCReader.readBool(_in);
        if (CAVLCReader.moreRBSPData(_in)) {
            pps.extended = new PPSExt();
            pps.extended.transform8x8ModeFlag = CAVLCReader.readBool(_in);
            boolean pic_scaling_matrix_present_flag = CAVLCReader.readBool(_in);
            if (pic_scaling_matrix_present_flag) {
                pps.extended.scalingMatrix = new int[8][];
                for (int i = 0; i < 6 + 2 * (pps.extended.transform8x8ModeFlag ? 1 : 0); ++i) {
                    int scalingListSize;
                    int n = scalingListSize = i < 6 ? 16 : 64;
                    if (!CAVLCReader.readBool(_in)) continue;
                    pps.extended.scalingMatrix[i] = SeqParameterSet.readScalingList(_in, scalingListSize);
                }
            }
            pps.extended.secondChromaQpIndexOffset = CAVLCReader.readSE(_in);
        }
        return pps;
    }

    public void write(ByteBuffer out) {
        BitWriter writer = new BitWriter(out);
        CAVLCWriter.writeUE(writer, this.picParameterSetId);
        CAVLCWriter.writeUE(writer, this.seqParameterSetId);
        CAVLCWriter.writeBool(writer, this.entropyCodingModeFlag);
        CAVLCWriter.writeBool(writer, this.picOrderPresentFlag);
        CAVLCWriter.writeUE(writer, this.numSliceGroupsMinus1);
        if (this.numSliceGroupsMinus1 > 0) {
            CAVLCWriter.writeUE(writer, this.sliceGroupMapType);
            if (this.sliceGroupMapType == 0) {
                for (iGroup = 0; iGroup <= this.numSliceGroupsMinus1; ++iGroup) {
                    CAVLCWriter.writeUE(writer, this.runLengthMinus1[iGroup]);
                }
            } else if (this.sliceGroupMapType == 2) {
                for (iGroup = 0; iGroup < this.numSliceGroupsMinus1; ++iGroup) {
                    CAVLCWriter.writeUE(writer, this.topLeft[iGroup]);
                    CAVLCWriter.writeUE(writer, this.bottomRight[iGroup]);
                }
            } else if (this.sliceGroupMapType == 3 || this.sliceGroupMapType == 4 || this.sliceGroupMapType == 5) {
                CAVLCWriter.writeBool(writer, this.sliceGroupChangeDirectionFlag);
                CAVLCWriter.writeUE(writer, this.sliceGroupChangeRateMinus1);
            } else if (this.sliceGroupMapType == 6) {
                int NumberBitsPerSliceGroupId = this.numSliceGroupsMinus1 + 1 > 4 ? 3 : (this.numSliceGroupsMinus1 + 1 > 2 ? 2 : 1);
                CAVLCWriter.writeUE(writer, this.sliceGroupId.length);
                for (int i = 0; i <= this.sliceGroupId.length; ++i) {
                    CAVLCWriter.writeU(writer, this.sliceGroupId[i], NumberBitsPerSliceGroupId);
                }
            }
        }
        CAVLCWriter.writeUE(writer, this.numRefIdxActiveMinus1[0]);
        CAVLCWriter.writeUE(writer, this.numRefIdxActiveMinus1[1]);
        CAVLCWriter.writeBool(writer, this.weightedPredFlag);
        CAVLCWriter.writeNBit(writer, this.weightedBipredIdc, 2, "");
        CAVLCWriter.writeSE(writer, this.picInitQpMinus26);
        CAVLCWriter.writeSE(writer, this.picInitQsMinus26);
        CAVLCWriter.writeSE(writer, this.chromaQpIndexOffset);
        CAVLCWriter.writeBool(writer, this.deblockingFilterControlPresentFlag);
        CAVLCWriter.writeBool(writer, this.constrainedIntraPredFlag);
        CAVLCWriter.writeBool(writer, this.redundantPicCntPresentFlag);
        if (this.extended != null) {
            CAVLCWriter.writeBool(writer, this.extended.transform8x8ModeFlag);
            CAVLCWriter.writeBool(writer, this.extended.scalingMatrix != null);
            if (this.extended.scalingMatrix != null) {
                for (int i = 0; i < 6 + 2 * (this.extended.transform8x8ModeFlag ? 1 : 0); ++i) {
                    CAVLCWriter.writeBool(writer, this.extended.scalingMatrix[i] != null);
                    if (this.extended.scalingMatrix[i] == null) continue;
                    SeqParameterSet.writeScalingList(writer, this.extended.scalingMatrix, i);
                }
            }
            CAVLCWriter.writeSE(writer, this.extended.secondChromaQpIndexOffset);
        }
        CAVLCWriter.writeTrailingBits(writer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bottomRight);
        result = 31 * result + this.chromaQpIndexOffset;
        result = 31 * result + (this.constrainedIntraPredFlag ? 1231 : 1237);
        result = 31 * result + (this.deblockingFilterControlPresentFlag ? 1231 : 1237);
        result = 31 * result + (this.entropyCodingModeFlag ? 1231 : 1237);
        result = 31 * result + (this.extended == null ? 0 : this.extended.hashCode());
        result = 31 * result + this.numRefIdxActiveMinus1[0];
        result = 31 * result + this.numRefIdxActiveMinus1[1];
        result = 31 * result + this.numSliceGroupsMinus1;
        result = 31 * result + this.picInitQpMinus26;
        result = 31 * result + this.picInitQsMinus26;
        result = 31 * result + (this.picOrderPresentFlag ? 1231 : 1237);
        result = 31 * result + this.picParameterSetId;
        result = 31 * result + (this.redundantPicCntPresentFlag ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.runLengthMinus1);
        result = 31 * result + this.seqParameterSetId;
        result = 31 * result + (this.sliceGroupChangeDirectionFlag ? 1231 : 1237);
        result = 31 * result + this.sliceGroupChangeRateMinus1;
        result = 31 * result + Arrays.hashCode(this.sliceGroupId);
        result = 31 * result + this.sliceGroupMapType;
        result = 31 * result + Arrays.hashCode(this.topLeft);
        result = 31 * result + this.weightedBipredIdc;
        result = 31 * result + (this.weightedPredFlag ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PictureParameterSet other = (PictureParameterSet)obj;
        if (!Arrays.equals(this.bottomRight, other.bottomRight)) {
            return false;
        }
        if (this.chromaQpIndexOffset != other.chromaQpIndexOffset) {
            return false;
        }
        if (this.constrainedIntraPredFlag != other.constrainedIntraPredFlag) {
            return false;
        }
        if (this.deblockingFilterControlPresentFlag != other.deblockingFilterControlPresentFlag) {
            return false;
        }
        if (this.entropyCodingModeFlag != other.entropyCodingModeFlag) {
            return false;
        }
        if (this.extended == null ? other.extended != null : !this.extended.equals(other.extended)) {
            return false;
        }
        if (this.numRefIdxActiveMinus1[0] != other.numRefIdxActiveMinus1[0]) {
            return false;
        }
        if (this.numRefIdxActiveMinus1[1] != other.numRefIdxActiveMinus1[1]) {
            return false;
        }
        if (this.numSliceGroupsMinus1 != other.numSliceGroupsMinus1) {
            return false;
        }
        if (this.picInitQpMinus26 != other.picInitQpMinus26) {
            return false;
        }
        if (this.picInitQsMinus26 != other.picInitQsMinus26) {
            return false;
        }
        if (this.picOrderPresentFlag != other.picOrderPresentFlag) {
            return false;
        }
        if (this.picParameterSetId != other.picParameterSetId) {
            return false;
        }
        if (this.redundantPicCntPresentFlag != other.redundantPicCntPresentFlag) {
            return false;
        }
        if (!Arrays.equals(this.runLengthMinus1, other.runLengthMinus1)) {
            return false;
        }
        if (this.seqParameterSetId != other.seqParameterSetId) {
            return false;
        }
        if (this.sliceGroupChangeDirectionFlag != other.sliceGroupChangeDirectionFlag) {
            return false;
        }
        if (this.sliceGroupChangeRateMinus1 != other.sliceGroupChangeRateMinus1) {
            return false;
        }
        if (!Arrays.equals(this.sliceGroupId, other.sliceGroupId)) {
            return false;
        }
        if (this.sliceGroupMapType != other.sliceGroupMapType) {
            return false;
        }
        if (!Arrays.equals(this.topLeft, other.topLeft)) {
            return false;
        }
        if (this.weightedBipredIdc != other.weightedBipredIdc) {
            return false;
        }
        return this.weightedPredFlag == other.weightedPredFlag;
    }

    public PictureParameterSet copy() {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        this.write(buf);
        buf.flip();
        return PictureParameterSet.read(buf);
    }

    public static class PPSExt {
        public boolean transform8x8ModeFlag;
        public int[][] scalingMatrix;
        public int secondChromaQpIndexOffset;
    }
}

