/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment;

import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.SegmentRefiner;

abstract class AbstractSegment
implements Segment {
    protected final DocumentRenderer document;
    protected final ManualModel model;
    protected final ManualStyle style;
    @Nullable
    private final Segment parent;
    protected Segment next;

    protected AbstractSegment(DocumentRenderer document, @Nullable Segment parent) {
        this.document = document;
        this.model = document.getModel();
        this.style = document.getStyle();
        this.parent = parent;
    }

    @Override
    public Segment getLineRoot() {
        return this.parent != null ? this.parent.getLineRoot() : this;
    }

    @Override
    public Optional<Segment> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Iterable<Segment> refine(Pattern pattern, SegmentRefiner refiner) {
        return Collections.singletonList(this);
    }

    @Override
    public void setNext(@Nullable Segment segment) {
        this.next = segment;
    }
}

