/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.provider;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.prefab.provider.AbstractRendererProvider;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.api.util.MatchResult;
import li.cil.manual.client.document.Strings;
import li.cil.manual.client.document.segment.render.ItemStackContentRenderer;
import li.cil.manual.client.document.segment.render.MissingContentRenderer;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BlockRendererProvider
extends AbstractRendererProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, BlockState> BLOCK_STATE_CACHE = new HashMap<String, BlockState>();

    public BlockRendererProvider() {
        super("block");
    }

    @Override
    public MatchResult matches(ManualModel manual) {
        return MatchResult.MATCH;
    }

    @Override
    protected Optional<ContentRenderer> doGetRenderer(String data) {
        BlockState state = Objects.requireNonNull(BLOCK_STATE_CACHE.computeIfAbsent(data, string -> {
            try {
                return BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(string), (boolean)false).f_234748_();
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("Failed parsing block state.", (Throwable)e);
                return Blocks.f_50016_.m_49966_();
            }
        }));
        if (state.m_60734_() != Blocks.f_50016_) {
            return Optional.of(new ItemStackContentRenderer(new ItemStack((ItemLike)state.m_60734_())));
        }
        return Optional.of(new MissingContentRenderer(Strings.NO_SUCH_BLOCK));
    }
}

