# 网络

要建立[电脑](block/computer.md)网络，需使用[网络连接器](block/network_connector.md)和用于接通连接器的[网络线缆](item/network_cable.md)。最后，确保每台要加入网络的电脑都安装了[网络接口卡](item/network_interface_card.md)。

连接器须连接在电脑的任意一面，正面除外。这样安装在电脑中的网络接口卡才能收发数据包。

通过线缆接通的连接器会相互转发数据包。对于更复杂的网络结构，可能需要使用[网络集线器](block/network_hub.md)。它能将多个连接器互相接通。

## 跳

网络数据包传输时的“跳数”有上限。一跳通常可以理解为一次转发操作。例如，连接器转发数据包时会使用一跳，网络集线器将数据包转发到除来源以外的连接器时也会使用一跳。一旦剩余跳数归零，数据包将不再被转发。这可以避免数据包在有环路的网络中无限循环，也就是说这是安全机制。网络不应出现环路，这会导致同一个数据包多次到达目标电脑。

## 配置电脑

要配置入网的电脑，首先应确保安装了网络接口卡。之后，在默认的Linux发行版中，运行命令`setup-network.lua`。该脚本将提供一个向导，配置电脑入网的方式。或者，如果你知道自己在做什么，可以像在普通Linux系统中那样设置网络。

## DHCP

DHCP是一种可以简单地进行网络配置的协议。网络中只需给一台电脑静态分配网络地址，其他所有电脑都可以被自动分配地址。使用此方法时，请确保只有一台电脑充当DHCP服务器，同时确保不要将动态分配范围内的IP地址分配给静态地址的电脑。

## 工具

一旦你有了运行中的网络，且网络中有多台电脑，你就有了无限的可能性。例如，你可以使用`scp`在电脑之间复制文件，使用`ssh`登录到远程电脑，以及在Lua中使用`socket`库编写自定义网络程序。请参阅[官方仓库中的示例](https://github.com/diegonehab/luasocket/tree/master/samples)以获取有关如何使用`socket`库的示例，。
