/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.DyeColor;

public class ModClientDynamicResources
extends DynamicClientResourceProvider {
    public ModClientDynamicResources() {
        super(SleepTight.res("generated_pack"), PackGenerationStrategy.REGEN_ON_EVERY_RELOAD);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("minecraft");
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            ResourceLocation res = ResourceLocation.withDefaultNamespace((String)"white_bed");
            Optional o = manager.getResource(ResType.BLOCKSTATES.getPath(res));
            if (o.isPresent() && !Objects.equals(((Resource)o.get()).sourcePackId(), "vanilla")) {
                return;
            }
            if (!PlatHelper.isModLoaded((String)"enhancedblockentities") && !PlatHelper.isModLoaded((String)"betterbeds")) {
                String str = "{\n  \"variants\": {\n    \"\": {\n      \"model\": \"sleep_tight:block/#_bed\"\n    }\n  }\n}";
                for (DyeColor c : DyeColor.values()) {
                    JsonElement json = JsonParser.parseString((String)str.replace("#", c.getName()));
                    sink.addJson(ResourceLocation.withDefaultNamespace((String)(c.getName() + "_bed")), json, ResType.BLOCKSTATES);
                }
            }
        });
    }

    protected void addDynamicTranslations(AfterLanguageLoadEvent afterLanguageLoadEvent) {
    }
}

