/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.client.renderers.BedbugModel;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class BedbugEntityRenderer<T extends BedbugEntity>
extends MobRenderer<T, BedbugModel<T>> {
    public BedbugEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new BedbugModel(context.bakeLayer(SleepTightClient.BEDBUG)), 0.4375f);
    }

    protected float getFlipDegrees(T livingEntity) {
        return 180.0f;
    }

    public Vec3 getRenderOffset(T entity, float partialTicks) {
        return super.getRenderOffset(entity, partialTicks).add(0.0, -0.01 * (double)((BedbugEntity)((Object)entity)).getBurrowing(partialTicks), 0.0);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return SleepTightClient.BEDBUG_TEXTURE;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.pushPose();
        matrixStack.scale(0.75f, 0.75f, 0.75f);
        super.render(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.popPose();
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition main = mesh.getRoot();
        float h = 18.5f;
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 8).addBox(-2.5f, 0.0f, -3.0f, 5.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)(h - 1.5f), (float)-9.0f, (float)((float)Math.toRadians(27.5)), (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("antenna", CubeListBuilder.create().texOffs(41, 0).addBox(-4.5f, -2.0f, 0.0f, 9.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.5f));
        main.addOrReplaceChild("body0", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -2.0f, -1.5f, 7.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)(h - 0.5f), (float)-7.5f));
        main.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 15).addBox(-5.5f, -2.5f, -6.0f, 11.0f, 5.0f, 12.0f), PartPose.offset((float)0.0f, (float)h, (float)0.0f));
        CubeListBuilder rightLeg = CubeListBuilder.create().texOffs(20, 0).addBox(-7.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f);
        CubeListBuilder leftLeg = CubeListBuilder.create().texOffs(20, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f);
        float w = 5.5f;
        float z2 = 3.5f;
        float z3 = 0.0f;
        float z4 = -3.5f;
        main.addOrReplaceChild("right_hind_leg", rightLeg, PartPose.offset((float)(-w), (float)(h += 0.5f), (float)z2));
        main.addOrReplaceChild("left_hind_leg", leftLeg, PartPose.offset((float)w, (float)h, (float)z2));
        main.addOrReplaceChild("right_middle_leg", rightLeg, PartPose.offset((float)(-w), (float)h, (float)z3));
        main.addOrReplaceChild("left_middle_leg", leftLeg, PartPose.offset((float)w, (float)h, (float)z3));
        main.addOrReplaceChild("right_front_leg", rightLeg, PartPose.offset((float)(-w), (float)h, (float)z4));
        main.addOrReplaceChild("left_front_leg", leftLeg, PartPose.offset((float)w, (float)h, (float)z4));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }
}

