/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.renderers;

import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class BedbugModel<T extends BedbugEntity>
extends HierarchicalModel<T> {
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleLeg;
    private final ModelPart leftMiddleLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart body;
    private final ModelPart antenna;
    private final ModelPart root;

    public BedbugModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.getChild("head");
        this.body = modelPart.getChild("body0");
        this.antenna = this.head.getChild("antenna");
        this.rightHindLeg = modelPart.getChild("right_hind_leg");
        this.leftHindLeg = modelPart.getChild("left_hind_leg");
        this.rightMiddleLeg = modelPart.getChild("right_middle_leg");
        this.leftMiddleLeg = modelPart.getChild("left_middle_leg");
        this.rightFrontLeg = modelPart.getChild("right_front_leg");
        this.leftFrontLeg = modelPart.getChild("left_front_leg");
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = (27.5f + headPitch) * ((float)Math.PI / 180);
        float fortyFive = 0.8853982f;
        float thirtyThree = 0.68119466f;
        float fortyFive2 = 0.5853982f;
        float h = 0.3926991f;
        this.rightHindLeg.zRot = -fortyFive;
        this.leftHindLeg.zRot = fortyFive;
        this.rightMiddleLeg.zRot = -thirtyThree;
        this.leftMiddleLeg.zRot = thirtyThree;
        this.rightFrontLeg.zRot = -fortyFive;
        this.leftFrontLeg.zRot = fortyFive;
        this.rightHindLeg.yRot = fortyFive2;
        this.leftHindLeg.yRot = -fortyFive2;
        this.rightMiddleLeg.yRot = 0.0f;
        this.leftMiddleLeg.yRot = 0.0f;
        this.rightFrontLeg.yRot = -fortyFive2;
        this.leftFrontLeg.yRot = fortyFive2;
        float speed = 1.8662f;
        float ampl = 0.5f;
        float ampl2 = 0.4f;
        float a1 = Mth.cos((float)(ageInTicks * 1.5f)) * (0.3f + limbSwingAmount) * 0.3f;
        this.antenna.xRot = 0.4f + a1;
        float c0 = -(Mth.cos((float)(limbSwing * speed * 2.0f + 0.0f)) * ampl) * limbSwingAmount;
        float c1 = -(Mth.cos((float)(limbSwing * speed * 2.0f + 4.1887903f)) * ampl) * limbSwingAmount;
        float c2 = -(Mth.cos((float)(limbSwing * speed * 2.0f + 2.0943952f)) * ampl) * limbSwingAmount;
        float s0 = Math.abs(Mth.sin((float)(limbSwing * speed + 0.0f)) * ampl2) * limbSwingAmount;
        float s1 = Math.abs(Mth.sin((float)(limbSwing * speed + 4.1887903f)) * ampl2) * limbSwingAmount;
        float s2 = Math.abs(Mth.sin((float)(limbSwing * speed + 2.0943952f)) * ampl2) * limbSwingAmount;
        float burrowing = ((BedbugEntity)((Object)entity)).getBurrowing(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
        if (burrowing != 0.0f) {
            limbSwing = burrowing * 1.6f;
            float k = 0.25f;
            s0 += (-1.0f + Mth.cos((float)limbSwing)) * k;
            s1 += (-1.0f + Mth.cos((float)(limbSwing + 0.5235988f))) * k;
            s2 += (-1.0f + Mth.cos((float)(limbSwing + 1.0471976f))) * k;
            float j = 0.35f;
            c0 += -Mth.sin((float)limbSwing) * j;
            c1 += -Mth.sin((float)(limbSwing + 0.5235988f)) * j;
            c2 += -Mth.sin((float)(limbSwing + 1.0471976f)) * j;
        }
        ModelPart leg = this.rightHindLeg;
        leg.yRot += c0;
        leg = this.leftHindLeg;
        leg.yRot += -c0;
        leg = this.rightMiddleLeg;
        leg.yRot += c1;
        leg = this.leftMiddleLeg;
        leg.yRot += -c1;
        leg = this.rightFrontLeg;
        leg.yRot += c2;
        leg = this.leftFrontLeg;
        leg.yRot += -c2;
        leg = this.rightHindLeg;
        leg.zRot += s0;
        leg = this.leftHindLeg;
        leg.zRot += -s0;
        leg = this.rightMiddleLeg;
        leg.zRot += s1;
        leg = this.leftMiddleLeg;
        leg.zRot += -s1;
        leg = this.rightFrontLeg;
        leg.zRot += s2;
        leg = this.leftFrontLeg;
        leg.zRot += -s2;
    }
}

