/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common;

import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class InvigoratedEffect
extends MobEffect {
    public static final ThreadLocal<Integer> BLOCK_XP_LEVEL = new ThreadLocal();

    public InvigoratedEffect(MobEffectCategory mobEffectCategory, int i) {
        super(mobEffectCategory, i);
    }

    public static void fabricOnBlockXpDropped(ServerLevel level, BlockPos pos, int oldXp) {
        Integer amp;
        if (oldXp > 0 && (amp = BLOCK_XP_LEVEL.get()) != null) {
            double extraXp = InvigoratedEffect.getExtraXp(oldXp, amp, level.random);
            ExperienceOrb.award((ServerLevel)level, (Vec3)pos.getCenter(), (int)((int)extraXp));
        }
    }

    public static int forgeGetExtraXpForBlockBroken(int i, Entity breaker) {
        LivingEntity le;
        MobEffectInstance e;
        if (breaker instanceof LivingEntity && (e = (le = (LivingEntity)breaker).getEffect(SleepTight.INVIGORATED.getHolder())) != null) {
            return (int)InvigoratedEffect.getExtraXp(i, e.getAmplifier(), le.getRandom());
        }
        return 0;
    }

    public static void onLivingDeath(ServerLevel serverLevel, LivingEntity entity, LivingEntity killer) {
        MobEffectInstance i = killer.getEffect(SleepTight.INVIGORATED.getHolder());
        if (i != null && entity.lastHurtByPlayerTime > 0 && !entity.wasExperienceConsumed() && !(entity instanceof Player) && entity.shouldDropExperience() && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            int oldXp = entity.getExperienceReward(serverLevel, (Entity)killer);
            int amp = i.getAmplifier();
            double extraXp = InvigoratedEffect.getExtraXp(oldXp, amp, serverLevel.random);
            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)entity.position(), (int)((int)extraXp));
        }
    }

    public static double getExtraXp(int oldXp, int invigoratingLevel, RandomSource random) {
        int actual;
        double value = (double)oldXp * CommonConfigs.INVIGORATED_XP.get() * (double)(invigoratingLevel + 1);
        double remainder = value - (double)(actual = (int)value);
        if (remainder != 0.0 && (double)random.nextFloat() < remainder) {
            ++actual;
        }
        return actual;
    }
}

