/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.entities.DreamerEssenceTargetEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DreamEssenceBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public DreamEssenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        if (context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).getEntity() instanceof Phantom) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Phantom) {
            level.destroyBlock(pos, false, entity);
        }
        super.entityInside(state, level, pos, entity);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        level.addFreshEntity((Entity)new DreamerEssenceTargetEntity(level, pos));
    }

    public static boolean isInRange(BlockPos pos, Level level) {
        if (level.isClientSide) {
            return SleepTightClient.getCachedDreamEssenceInRange(pos, level);
        }
        return DreamEssenceBlock.isInRangeInternal(pos, level);
    }

    public static boolean isInRangeInternal(BlockPos pos, Level level) {
        return !level.getEntitiesOfClass(DreamerEssenceTargetEntity.class, new AABB(pos).inflate(5.0)).isEmpty();
    }
}

