/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.ModEvents;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.integration.QuarkCompat;
import net.mehvahdjukaar.sleep_tight.integration.SupplementariesCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HammockBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IRotatable,
IModBed {
    public static final MapCodec<HammockBlock> CODEC = DyeColor.CODEC.fieldOf("color").xmap(HammockBlock::new, HammockBlock::getColor);
    public static final EnumProperty<HammockPart> PART = EnumProperty.create((String)"part", HammockPart.class);
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final VoxelShape SHAPE_FULL = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)3.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)8.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)3.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color.getMapColor()).pushReaction(PushReaction.DESTROY).sound(SoundType.WOOL).strength(0.2f).noOcclusion());
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)HammockPart.MIDDLE))).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance * 0.8f);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        HammockPart part = (HammockPart)((Object)state.getValue(PART));
        Direction myDir = (Direction)state.getValue((Property)FACING);
        if (direction.getAxis() == myDir.getAxis()) {
            Connection c;
            Direction attDir;
            for (Pair<Direction, HammockPart> v : part.getPiecesDirections(myDir)) {
                if (v.getFirst() != direction) continue;
                Block block = neighborState.getBlock();
                if (block instanceof HammockBlock) {
                    HammockBlock nh = (HammockBlock)block;
                    if (neighborState.getValue(PART) != v.getSecond() || neighborState.getValue((Property)FACING) != myDir) break;
                    BlockState newState = neighborState.is((Block)this) ? state : BlocksColorAPI.changeColor((Block)state.getBlock(), (DyeColor)nh.color).withPropertiesOf(state);
                    return (BlockState)newState.setValue((Property)OCCUPIED, (Comparable)((Boolean)neighborState.getValue((Property)OCCUPIED)));
                }
                return Blocks.AIR.defaultBlockState();
            }
            if ((attDir = part.getConnectionDirection(myDir)) == direction && ((c = HammockBlock.getConnectionType(attDir, currentPos, level)) == Connection.NONE || c == Connection.FENCE != part.isOnFence())) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        int i;
        HammockPart part;
        if (!level.isClientSide && player.isCreative() && !(part = (HammockPart)((Object)state.getValue(PART))).isMaster() && (i = part.getMasterOffset()) != 0 && (blockState = level.getBlockState(blockPos = pos.relative((Direction)state.getValue((Property)FACING), i))).is((Block)this) && ((HammockPart)((Object)blockState.getValue(PART))).isMaster()) {
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        for (Direction dir : context.getNearestLookingDirections()) {
            if (!dir.getAxis().isHorizontal()) continue;
            for (int i = 0; i < 2; ++i) {
                Direction opposite;
                BlockPos nextPos;
                Connection type;
                BlockPos p = pos.relative(dir, i);
                if (!level.getBlockState(p).canBeReplaced(context) || !level.getWorldBorder().isWithinBounds(p) || ((type = HammockBlock.getConnectionType(dir, p, (LevelAccessor)level)) != Connection.FENCE || i == 1) && type != Connection.BLOCK || !level.getBlockState(nextPos = p.relative(opposite = dir.getOpposite())).canBeReplaced(context) || !level.getWorldBorder().isWithinBounds(nextPos) || type == Connection.BLOCK && (!level.getBlockState(nextPos = nextPos.relative(opposite)).canBeReplaced(context) || !level.getWorldBorder().isWithinBounds(nextPos)) || HammockBlock.getConnectionType(opposite, nextPos, (LevelAccessor)level) != type) continue;
                HammockPart t = i == 1 ? HammockPart.MIDDLE : type.getHead();
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue(PART, (Comparable)((Object)t));
            }
        }
        return null;
    }

    private static Connection getConnectionType(Direction dir, BlockPos pos, LevelAccessor level) {
        Direction opposite;
        BlockPos relative = pos.relative(dir);
        BlockState facingState = level.getBlockState(relative);
        if (facingState.isFaceSturdy((BlockGetter)level, relative, opposite = dir.getOpposite(), SupportType.CENTER)) {
            return Connection.BLOCK;
        }
        if (facingState.getBlock() instanceof FenceBlock || SleepTight.QUARK && QuarkCompat.isVerticalPost(facingState) || SleepTight.SUPP && SupplementariesCompat.isRopeKnot(facingState)) {
            return Connection.FENCE;
        }
        return Connection.NONE;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            HammockPart part = (HammockPart)((Object)state.getValue(PART));
            for (Pair<Direction, HammockPart> v : part.getPiecesDirections((Direction)state.getValue((Property)FACING))) {
                BlockPos blockPos = pos.relative((Direction)v.getFirst());
                level.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)((Object)((HammockPart)((Object)v.getSecond())))), 3);
                if (part != HammockPart.HALF_HEAD) continue;
                blockPos = blockPos.relative((Direction)v.getFirst());
                level.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)((Object)HammockPart.HALF_FOOT)), 3);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        HammockPart part = (HammockPart)((Object)state.getValue(PART));
        if (part.isOnFence() || part == HammockPart.MIDDLE) {
            return SHAPE_FULL;
        }
        return switch (part.getConnectionDirection((Direction)state.getValue((Property)FACING))) {
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            default -> SHAPE_NORTH;
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, PART, OCCUPIED});
    }

    public long getSeed(BlockState state, BlockPos pos) {
        BlockPos blockPos = HammockBlock.getMasterPos(state, pos);
        return Mth.getSeed((int)blockPos.getX(), (int)pos.getY(), (int)blockPos.getZ());
    }

    private static BlockPos getMasterPos(BlockState state, BlockPos pos) {
        return pos.relative((Direction)state.getValue((Property)FACING), ((HammockPart)((Object)state.getValue(PART))).getMasterOffset());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((HammockPart)((Object)state.getValue(PART))).isMaster() ? new HammockTile(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? Utils.getTicker(type, SleepTight.HAMMOCK_TILE.get(), HammockTile::tick) : null;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        return super.triggerEvent(state, level, pos, id, param);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!(state = level.getBlockState(pos = HammockBlock.getMasterPos(state, pos))).is((Block)this) || player.getVehicle() != null) {
            return InteractionResult.FAIL;
        }
        if (IModBed.tryExploding(level, pos)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        BedEntity.layDown(state, pos, player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public Vec3 getSleepingPosition(BlockState state, BlockPos pos) {
        Vec3 v = Vec3.atCenterOf((Vec3i)pos).subtract(0.0, 0.125, 0.0);
        float off = 0.09375f;
        if (!((HammockPart)((Object)state.getValue(PART))).isOnFence()) {
            off += 0.5f;
        }
        v = v.relative((Direction)state.getValue((Property)FACING), (double)off);
        return v;
    }

    @Override
    public boolean canSetSpawn() {
        return false;
    }

    @Override
    public InteractionResult canSleepAtTime(Level level) {
        return ModEvents.isDayTime(level) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Override
    public Component getSleepingProblemMessage() {
        return Component.translatable((String)"message.sleep_tight.cant_rest");
    }

    @Override
    public boolean st_canCauseNightmares() {
        return CommonConfigs.NIGHTMARES_HAMMOCK.get();
    }

    @Override
    public long st_getCooldown() {
        return CommonConfigs.HAMMOCK_COOLDOWN.get().intValue();
    }

    @Override
    public boolean st_hasPenalties() {
        return CommonConfigs.PENALTIES_HAMMOCK.get();
    }

    @Override
    public boolean st_hasRequirements() {
        return CommonConfigs.REQUIREMENT_HAMMOCK.get();
    }

    @Override
    public boolean st_canSpawnBedbugs() {
        return false;
    }

    @Override
    public long st_modifyWakeUpTime(WakeReason reason, long newTime, long dayTime) {
        if (reason == WakeReason.SLEPT_SUCCESSFULLY) {
            long i = dayTime + 24000L;
            return i - i % 24000L - 11001L;
        }
        return IModBed.super.st_modifyWakeUpTime(reason, newTime, dayTime);
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.empty();
    }

    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return super.rotateOverAxis(state, world, pos, rotation, axis, hit);
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public void setBedOccupied(BlockState state, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    public Direction getBedDirection(BlockState state, LevelReader level, BlockPos pos) {
        return (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    private static enum Connection {
        BLOCK,
        FENCE,
        NONE;


        public HammockPart getHead() {
            return this == BLOCK ? HammockPart.HALF_HEAD : HammockPart.HEAD;
        }
    }
}

