/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface IModBed
extends ISleepTightBed {
    public Vec3 getSleepingPosition(BlockState var1, BlockPos var2);

    default public void onLeftBed(BlockState state, BlockPos pos, Player entity) {
    }

    public boolean canSetSpawn();

    default public Component getSleepingProblemMessage() {
        return Component.empty();
    }

    default public InteractionResult canSleepAtTime(Level level) {
        return InteractionResult.PASS;
    }

    public static boolean tryExploding(Level level, BlockPos pos) {
        if (!BedBlock.canSetSpawn((Level)level)) {
            if (!level.isClientSide) {
                CommonConfigs.ExplosionBehavior c = CommonConfigs.EXPLOSION_BEHAVIOR.get();
                if (c == CommonConfigs.ExplosionBehavior.ALLOWS_SLEEPING) {
                    return false;
                }
                level.removeBlock(pos, false);
                float size = c == CommonConfigs.ExplosionBehavior.TINY_EXPLOSION ? 0.0f : 5.0f;
                level.explode(null, level.damageSources().badRespawnPointExplosion(pos.getCenter()), null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, size, true, Level.ExplosionInteraction.BLOCK);
            }
            return true;
        }
        return false;
    }
}

