/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NightBagBlock
extends BedBlock
implements IModBed {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SHAPE_HACK = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));

    public NightBagBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.BLUE, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)PART) == BedPart.HEAD ? SHAPE_HACK : SHAPE;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance * 2.0f);
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    @Override
    public Vec3 getSleepingPosition(BlockState state, BlockPos pos) {
        return Vec3.atCenterOf((Vec3i)pos).subtract(0.0, 0.25, 0.0);
    }

    @Override
    public boolean canSetSpawn() {
        return false;
    }

    @Override
    public boolean st_canCauseNightmares() {
        return CommonConfigs.NIGHTMARES_HAMMOCK.get();
    }

    @Override
    public long st_getCooldown() {
        return CommonConfigs.NIGHT_BAG_COOLDOWN.get().intValue();
    }

    @Override
    public boolean st_hasPenalties() {
        return CommonConfigs.PENALTIES_NIGHT_BAG.get();
    }

    @Override
    public boolean st_hasRequirements() {
        return CommonConfigs.REQUIREMENT_NIGHT_BAG.get();
    }

    @Override
    public boolean st_canSpawnBedbugs() {
        return false;
    }

    @Override
    public void onLeftBed(BlockState state, BlockPos pos, Player player) {
        Level level = player.level();
        level.removeBlock(pos, false);
        BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        if (level.getBlockState(blockPos).is((Block)this)) {
            level.removeBlock(blockPos, false);
        }
        InteractionHand hand = player.getUsedItemHand();
        ItemStack stack = new ItemStack((ItemLike)this);
        if (!player.getAbilities().instabuild) {
            if (player.getItemInHand(hand).isEmpty()) {
                player.setItemInHand(hand, stack);
            } else if (!player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockPos = context.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(direction);
        Level level = context.getLevel();
        return level.getBlockState(blockPos2).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockPos2) && this.isSupporting(level, blockPos.below()) && this.isSupporting(level, blockPos2.below()) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PART, (Comparable)BedPart.HEAD)).setValue((Property)FACING, (Comparable)direction.getOpposite()) : null;
    }

    private boolean isSupporting(Level level, BlockPos blockPos) {
        return level.getBlockState(blockPos).isFaceSturdy((BlockGetter)level, blockPos, Direction.UP);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (state.getValue((Property)PART) == BedPart.HEAD && !level.isClientSide) {
            BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            level.setBlock(blockPos, (BlockState)state.setValue((Property)PART, (Comparable)BedPart.FOOT), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
            if (CommonConfigs.NIGHT_BAG_BORING.get().booleanValue()) {
                return;
            }
            if (placer instanceof Player) {
                Player player = (Player)placer;
                this.useWithoutItem(state, level, pos, player, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)pos), Direction.DOWN, pos, false));
            }
        } else {
            super.setPlacedBy(level, pos, state, placer, stack);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !neighborState.isFaceSturdy((BlockGetter)level, neighborPos, Direction.UP)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }
}

