/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundAlightCameraOnLayMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSleepImmediatelyMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundCommitSleepMessage;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BedEntity
extends Entity
implements IControllableVehicle,
IExtraClientSpawnData {
    private static final EntityDataAccessor<OffsetMode> DATA_OFFSET = SynchedEntityData.defineId(BedEntity.class, SleepTight.OFFSET_MODE_SERIALIZER.get());
    private Direction dir = Direction.NORTH;
    private BlockState lastBedState = Blocks.AIR.defaultBlockState();
    private boolean dismountOnTheSpot = false;

    public BedEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BedEntity(Level worldIn, BlockPos mainPos, BlockState bedState, OffsetMode offsetMode) {
        super(SleepTight.BED_ENTITY.get(), worldIn);
        Direction bedDir = (Direction)bedState.getValue((Property)BedBlock.FACING);
        this.dir = bedDir.getOpposite();
        this.setYRot(this.dir.toYRot());
        this.lastBedState = bedState;
        this.setOffsetMode(offsetMode);
        VoxelShape shape = bedState.getShape((BlockGetter)worldIn, mainPos);
        double yOffset = shape.max(Direction.Axis.Y);
        this.setPos((double)mainPos.getX() + 0.5, (double)mainPos.getY() + yOffset, (double)mainPos.getZ() + 0.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_OFFSET, (Object)OffsetMode.NONE);
    }

    public OffsetMode getOffsetMode() {
        return (OffsetMode)((Object)this.entityData.get(DATA_OFFSET));
    }

    public void setOffsetMode(OffsetMode mode) {
        this.entityData.set(DATA_OFFSET, (Object)mode);
    }

    public Direction getBedDirection() {
        return this.dir;
    }

    public boolean isDoubleBed() {
        return this.getOffsetMode() == OffsetMode.DOUBLE_BED;
    }

    public void clearDoubleBed() {
        if (this.getOffsetMode() == OffsetMode.DOUBLE_BED) {
            this.setOffsetMode(OffsetMode.NONE);
            BlockPos otherPos = this.getDoubleBedPos();
            Level level = this.level();
            BlockState otherState = level.getBlockState(otherPos);
            if (otherState == this.lastBedState) {
                level.setBlockAndUpdate(otherPos, (BlockState)otherState.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void tick() {
        BlockPos otherPos;
        super.tick();
        Level level = this.level();
        List passengers = this.getPassengers();
        for (Entity p : passengers) {
            p.setPose(Pose.SLEEPING);
            if (this.tickCount <= 2 || level.isClientSide || !CommonConfigs.SLEEP_IMMEDIATELY.get().booleanValue() || !(p instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)p;
            this.startSleepingOn(sp);
        }
        boolean dead = passengers.isEmpty();
        BlockPos pos = this.blockPosition();
        BlockState newBedState = level.getBlockState(pos);
        boolean isBed = this.isValidBed(newBedState);
        if (this.isDoubleBed() && this.tickCount > 2 && level.getBlockState(otherPos = this.getDoubleBedPos()) != newBedState) {
            this.clearDoubleBed();
        }
        if (isBed) {
            this.dir = ((Direction)newBedState.getValue((Property)BedBlock.FACING)).getOpposite();
        }
        if (!dead && !isBed) {
            PistonMovingBlockEntity pistonBE;
            PistonMovingBlockEntity piston = null;
            boolean didOffsetByPiston = false;
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile instanceof PistonMovingBlockEntity && this.isValidBed((pistonBE = (PistonMovingBlockEntity)tile).getMovedState())) {
                piston = pistonBE;
            } else {
                for (Direction d : Direction.values()) {
                    PistonMovingBlockEntity pistonBE2;
                    BlockPos offPos = pos.relative(d);
                    tile = level.getBlockEntity(offPos);
                    if (!(tile instanceof PistonMovingBlockEntity) || !this.isValidBed((pistonBE2 = (PistonMovingBlockEntity)tile).getMovedState())) continue;
                    piston = pistonBE2;
                    break;
                }
            }
            if (piston != null) {
                Direction dir = piston.getMovementDirection();
                this.move(MoverType.PISTON, new Vec3((double)dir.getStepX() * 0.33, (double)dir.getStepY() * 0.33, (double)dir.getStepZ() * 0.33));
                didOffsetByPiston = true;
                this.clearDoubleBed();
            }
            boolean bl = dead = !didOffsetByPiston;
        }
        if (dead && !level.isClientSide) {
            if (isBed) {
                level.setBlockAndUpdate(pos, (BlockState)newBedState.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
            }
            this.clearDoubleBed();
            this.discard();
        }
        this.lastBedState = newBedState;
    }

    public static Vec3 getDoubleBedOffset(Direction dir, Vec3 vec3) {
        Direction d = dir.getCounterClockWise();
        return vec3.add((double)d.getStepX() * -0.5, 0.0, (double)d.getStepZ() * -0.5);
    }

    public static BlockPos getDoubleBedPos(BlockPos pos, BlockState state) {
        return pos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getClockWise());
    }

    public static BlockPos getInverseDoubleBedPos(BlockPos pos, BlockState state) {
        return pos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getCounterClockWise());
    }

    public BlockPos getDoubleBedPos() {
        return this.blockPosition().relative(this.dir.getCounterClockWise());
    }

    private boolean isValidBed(BlockState state) {
        Block b = state.getBlock();
        if (b instanceof BedBlock) {
            return state.getValue((Property)BedBlock.PART) == BedPart.HEAD;
        }
        if (b instanceof HammockBlock) {
            return ((HammockPart)((Object)state.getValue(HammockBlock.PART))).isMaster();
        }
        return false;
    }

    public boolean shouldRender(double x, double y, double z) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return false;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        this.setOffsetMode(OffsetMode.values()[compound.getByte("mode")]);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putByte("mode", (byte)this.getOffsetMode().ordinal());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return PlatHelper.getEntitySpawnPacket((Entity)this, (ServerEntity)entity);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        if (this.hasPassenger(passenger)) {
            Block block = this.lastBedState.getBlock();
            if (block instanceof IModBed) {
                IModBed b = (IModBed)block;
                Vec3 v = b.getSleepingPosition(this.lastBedState, this.blockPosition());
                callback.accept(passenger, v.x, v.y, v.z);
            } else {
                Vec3 c = this.position();
                if (this.isDoubleBed()) {
                    c = BedEntity.getDoubleBedOffset(this.dir.getOpposite(), c);
                }
                callback.accept(passenger, c.x, c.y, c.z);
            }
        }
    }

    public void onPassengerTurned(Entity entity) {
        float diff = Mth.wrapDegrees((float)(entity.getYHeadRot() - this.getYRot()));
        float clampedDiff = Mth.clamp((float)diff, (float)-90.0f, (float)90.0f);
        float subtract = clampedDiff - diff;
        ((LivingEntity)entity).yHeadRot += subtract;
        entity.setXRot(Mth.clamp((float)entity.getXRot(), (float)-75.0f, (float)0.0f));
    }

    protected void addPassenger(Entity passenger) {
        Player player;
        super.addPassenger(passenger);
        this.positionRider(passenger);
        passenger.setYRot(this.getYRot());
        passenger.setOldPosAndRot();
        passenger.setPose(Pose.SLEEPING);
        if (passenger instanceof Player && (player = (Player)passenger).isLocalPlayer()) {
            ClientEvents.displayRidingMessage(this);
            BedEntity.alignCamera(player, this.getYRot());
        }
    }

    public static void alignCamera(Player player, float bedYRot) {
        player.setYRot(bedYRot);
        player.setYHeadRot(bedYRot);
        player.yRotO = player.getYRot();
        player.yHeadRotO = player.yHeadRot;
    }

    protected void removePassenger(Entity passenger) {
        Player p;
        super.removePassenger(passenger);
        this.positionRider(passenger);
        if (passenger instanceof Player && (p = (Player)passenger).isSleeping()) {
            passenger.setPose(Pose.SLEEPING);
        } else {
            passenger.setPose(Pose.STANDING);
        }
    }

    public void onInputUpdate(boolean left, boolean right, boolean up, boolean down, boolean sprint, boolean jumping) {
        BlockEntity blockEntity;
        if (jumping) {
            NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundCommitSleepMessage());
            if (this.level().isClientSide && SleepTightClient.HAS_SNORE) {
                ((Entity)this.getPassengers().get(0)).playSound(SleepTight.SNORE_SOUND.get(), 1.0f, Mth.randomBetween((RandomSource)this.random, (float)0.9f, (float)1.1f));
            }
        } else if (left ^ right && (blockEntity = this.level().getBlockEntity(this.getOnPos())) instanceof HammockTile) {
            HammockTile tile = (HammockTile)blockEntity;
            if (left) {
                tile.accelerateLeft();
            } else {
                tile.accelerateRight();
            }
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.dir.get2DDataValue());
        buf.writeInt(this.getOffsetMode().ordinal());
        boolean isValid = !this.getPassengers().isEmpty();
        buf.writeBoolean(isValid);
        if (isValid) {
            buf.writeUUID(((Entity)this.getPassengers().get(0)).getUUID());
        }
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        this.dir = Direction.from2DDataValue((int)buf.readInt());
        this.setOffsetMode(OffsetMode.values()[buf.readInt()]);
        if (buf.readBoolean()) {
            UUID uniqueId = buf.readUUID();
            Player p = this.level().getPlayerByUUID(uniqueId);
            if (p != null) {
                p.startRiding((Entity)this);
            }
        }
    }

    public MutableComponent getRidingMessage(Component keyMessage, Component shiftMessage) {
        this.lastBedState = this.level().getBlockState(this.blockPosition());
        if (this.lastBedState.getBlock() instanceof HammockBlock) {
            return Component.translatable((String)"message.sleep_tight.start_resting", (Object[])new Object[]{keyMessage, shiftMessage});
        }
        return Component.translatable((String)"message.sleep_tight.start_sleeping", (Object[])new Object[]{keyMessage, shiftMessage});
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return true;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        if (this.dismountOnTheSpot) {
            return super.getDismountLocationForPassenger(passenger);
        }
        Optional o = BedBlock.findStandUpPosition((EntityType)passenger.getType(), (CollisionGetter)passenger.level(), (BlockPos)this.blockPosition(), (Direction)this.dir.getOpposite(), (float)passenger.getYRot());
        return o.orElseGet(() -> super.getDismountLocationForPassenger(passenger));
    }

    private static boolean isHammock3L(BlockState state) {
        return state.getBlock() instanceof HammockBlock && !((HammockPart)((Object)state.getValue(HammockBlock.PART))).isOnFence();
    }

    public void startSleepingOn(ServerPlayer player) {
        BlockPos pos = this.blockPosition();
        if (!this.isValidBed(this.level().getBlockState(pos))) {
            return;
        }
        this.dismountOnTheSpot = true;
        Either r = player.startSleepInBed(pos);
        this.dismountOnTheSpot = false;
        Optional op = r.left();
        if (op.isPresent()) {
            Component m;
            Block block;
            player.startRiding((Entity)this, true);
            Player.BedSleepingProblem problem = (Player.BedSleepingProblem)op.get();
            if (problem == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && (block = this.lastBedState.getBlock()) instanceof IModBed) {
                IModBed mb = (IModBed)block;
                m = mb.getSleepingProblemMessage();
            } else {
                m = problem.getMessage();
            }
            if (m != null) {
                player.displayClientMessage(m, true);
            }
        } else {
            player.removeVehicle();
            PlayerSleepData data = STPlatStuff.getPlayerSleepData((Player)player);
            data.setDoubleBed(this.isDoubleBed());
            data.syncToClient(player);
            NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundSleepImmediatelyMessage(pos));
            Level level = this.level();
            BlockState blockState = level.getBlockState(pos);
            if (blockState.getBlock() instanceof BedBlock) {
                level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
            }
            this.discard();
        }
    }

    public static void layDown(BlockState state, BlockPos pos, Player player) {
        Level level = player.level();
        if (!level.isClientSide) {
            OffsetMode mode = OffsetMode.NONE;
            if (BedEntity.isHammock3L(state)) {
                mode = OffsetMode.HAMMOCK_3L;
            }
            if (CommonConfigs.DOUBLE_BED.get().booleanValue() && state.is(BlockTags.BEDS)) {
                Direction dir = ((Direction)state.getValue((Property)BedBlock.FACING)).getClockWise();
                BlockPos relative = pos.relative(dir);
                BlockState s = level.getBlockState(relative);
                if (s == state) {
                    level.setBlockAndUpdate(relative, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
                    mode = OffsetMode.DOUBLE_BED;
                } else {
                    relative = pos.relative(dir = dir.getOpposite());
                    s = level.getBlockState(relative);
                    if (s == state) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
                        mode = OffsetMode.DOUBLE_BED;
                        pos = relative;
                    }
                }
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
            BedEntity bedEntity = new BedEntity(level, pos, state, mode);
            player.startRiding((Entity)bedEntity);
            level.addFreshEntity((Entity)bedEntity);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHelper.sendToClientPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientBoundAlightCameraOnLayMessage(bedEntity));
            }
        } else {
            BlockEntity mode = level.getBlockEntity(pos);
            if (mode instanceof HammockTile) {
                HammockTile tile = (HammockTile)mode;
                Vec3 d = player.getDeltaMovement();
                double vel = d.dot(MthUtils.V3itoV3((Vec3i)tile.getDirection().getClockWise().getNormal())) / d.length();
                tile.addImpulse((float)(-vel * (double)1.1f));
            }
        }
    }

    public static enum OffsetMode {
        NONE,
        HAMMOCK_3L,
        DOUBLE_BED;

        public static final IntFunction<OffsetMode> BY_ID;
        public static final StreamCodec<ByteBuf, OffsetMode> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])OffsetMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

