/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BedbugEntity
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(BedbugEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private BlockPos targetBed;
    private int burrowingTicks = 0;
    private int prevBurrowingTicks = 0;

    public BedbugEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public BedbugEntity(Level level) {
        super((EntityType)SleepTight.BEDBUG_ENTITY.get(), level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(2, (Goal)new InfestBedGoal(this, 1.0, 20));
        this.goalSelector.addGoal(3, (Goal)new BedbugLeapGoal((Mob)this, 0.25f));
        this.goalSelector.addGoal(4, (Goal)new BedbugAttackGoal(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    public float getBurrowing(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevBurrowingTicks, (float)this.burrowingTicks);
    }

    public int getMaxHeadYRot() {
        return 0;
    }

    public int getMaxHeadXRot() {
        return 20;
    }

    public void tick() {
        super.tick();
        if (this.getTarget() != null) {
            this.getLookControl().setLookAt((Entity)this.getTarget());
        }
        Level level = this.level();
        if (!level.isClientSide) {
            this.setClimbing(this.horizontalCollision);
        } else {
            this.prevBurrowingTicks = this.burrowingTicks;
        }
        if (this.isBurrowing()) {
            BlockPos pos = this.blockPosition();
            BlockState feetBlockState = level.getBlockState(pos);
            if (!(feetBlockState.getBlock() instanceof BedBlock)) {
                this.setBurrowing(false);
            } else {
                ++this.burrowingTicks;
                if (level.isClientSide) {
                    for (int i = 0; i < 6 + level.random.nextInt(10); ++i) {
                        float x = (float)pos.getX() + level.random.nextFloat();
                        float z = (float)pos.getZ() + level.random.nextFloat();
                        float y = (float)pos.getY() + 0.5625f;
                        level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, feetBlockState), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                    }
                } else if (this.burrowingTicks > 40) {
                    if (BedbugEggsItem.infestBed(level, pos, this)) {
                        this.spawnAnim();
                        this.discard();
                        level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.HOSTILE, 1.0f, 1.0f);
                    } else {
                        this.setBurrowing(false);
                    }
                } else if (this.burrowingTicks % 4 == 0) {
                    level.playSound(null, pos, SoundEvents.WOOL_HIT, SoundSource.HOSTILE, 0.5f, 1.2f);
                }
            }
        } else if (this.burrowingTicks > 0) {
            this.burrowingTicks = Math.max(0, this.burrowingTicks - 4);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
    }

    protected SoundEvent getAmbientSound() {
        return SleepTight.BEDBUG_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SleepTight.BEDBUG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return SleepTight.BEDBUG_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SILVERFISH_STEP, 0.15f, 1.0f);
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplier) {
        if (!state.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(state, motionMultiplier);
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public boolean isSplattered() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 3) != 0;
    }

    public boolean isBurrowing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 5) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b);
    }

    public void setSplattered(boolean splattered) {
        byte b = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b = splattered ? (byte)(b | 3) : (byte)(b & 0xFFFFFFFD);
        this.entityData.set(DATA_FLAGS_ID, (Object)b);
    }

    public void setBurrowing(boolean burrowing) {
        byte b = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b = burrowing ? (byte)(b | 5) : (byte)(b & 0xFFFFFFFB);
        this.entityData.set(DATA_FLAGS_ID, (Object)b);
    }

    protected PathNavigation createNavigation(Level level) {
        return new BedbugNavigation(this, level);
    }

    public void setBedTarget(BlockPos pos) {
        this.targetBed = new BlockPos((Vec3i)pos);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("targetBed")) {
            this.targetBed = NbtUtils.readBlockPos((CompoundTag)compound, (String)"targetBed").orElse(null);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.targetBed != null) {
            compound.put("targetBed", NbtUtils.writeBlockPos((BlockPos)this.targetBed));
        }
    }

    protected void onInsideBlock(BlockState state, BlockPos pos) {
        VoxelShape voxelShape;
        VoxelShape voxelShape2;
        if (state.getBlock() instanceof DoorBlock && Shapes.joinIsNotEmpty((VoxelShape)(voxelShape2 = (voxelShape = state.getCollisionShape((BlockGetter)this.level(), pos)).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())), (VoxelShape)Shapes.create((AABB)this.getBoundingBox()), (BooleanOp)BooleanOp.AND)) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)ClientBoundParticleMessage.bedbugDoor(pos));
            this.makeStuckInBlock(state, new Vec3(0.5, 0.5, 0.5));
        }
        super.onInsideBlock(state);
    }

    protected void checkInsideBlocks() {
        AABB aABB = this.getBoundingBox();
        BlockPos blockPos = BlockPos.containing((double)(aABB.minX + 0.001), (double)(aABB.minY + 0.001), (double)(aABB.minZ + 0.001));
        BlockPos blockPos2 = BlockPos.containing((double)(aABB.maxX - 0.001), (double)(aABB.maxY - 0.001), (double)(aABB.maxZ - 0.001));
        Level level = this.level();
        if (level.hasChunksAt(blockPos, blockPos2)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = blockPos.getX(); i <= blockPos2.getX(); ++i) {
                for (int j = blockPos.getY(); j <= blockPos2.getY(); ++j) {
                    for (int k = blockPos.getZ(); k <= blockPos2.getZ(); ++k) {
                        mutableBlockPos.set(i, j, k);
                        BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos);
                        try {
                            blockState.entityInside(level, (BlockPos)mutableBlockPos, (Entity)this);
                            this.onInsideBlock(blockState, (BlockPos)mutableBlockPos);
                            continue;
                        }
                        catch (Exception e) {
                            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Colliding entity with block");
                            CrashReportCategory crashReportCategory = crashReport.addCategory("Block being collided with");
                            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)level, (BlockPos)mutableBlockPos, (BlockState)blockState);
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    public boolean canCollideWith(Entity entity) {
        return super.canCollideWith(entity);
    }

    public boolean isColliding(BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof DoorBlock) {
            return false;
        }
        return super.isColliding(pos, state);
    }

    public static boolean isValidBedForInfestation(BlockState state) {
        Block block = state.getBlock();
        return block instanceof BedBlock && (Boolean)state.getValue((Property)BedBlock.OCCUPIED) == false;
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 9.0).add(Attributes.MOVEMENT_SPEED, 0.325).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (spawnType == MobSpawnType.EVENT && level.getDifficulty() != Difficulty.PEACEFUL) {
            int maxLight = CommonConfigs.BEDBUG_MAX_LIGHT.get();
            if (maxLight < 15) {
                int light = Math.max(level.getBrightness(LightLayer.BLOCK, pos), level.getBrightness(LightLayer.SKY, pos));
                return light <= maxLight;
            }
            return true;
        }
        return Monster.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    static class InfestBedGoal
    extends MoveToBlockGoal {
        private final List<BlockPos> blacklist = new ArrayList<BlockPos>();
        private final BedbugEntity bedBug;
        private final int searchRange;
        private int ticksOnTarget = 0;
        private boolean reachedTarget;

        public InfestBedGoal(BedbugEntity pathfinderMob, double speed, int searchRange) {
            super((PathfinderMob)pathfinderMob, speed, searchRange);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
            this.bedBug = pathfinderMob;
            this.searchRange = searchRange;
        }

        protected boolean isReachedTarget() {
            return this.reachedTarget;
        }

        protected BlockPos getMoveToTarget() {
            return this.blockPos;
        }

        public void tick() {
            BlockPos blockPos = this.getMoveToTarget();
            double dist = blockPos.distToCenterSqr((Position)this.mob.position());
            if (dist >= 1.0) {
                this.reachedTarget = false;
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    double s = this.speedModifier;
                    if (dist < 2.25) {
                        s /= 2.0;
                    }
                    this.mob.getNavigation().moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.25, (double)blockPos.getZ() + 0.5, s);
                }
            } else {
                this.reachedTarget = true;
                --this.tryTicks;
            }
            if (this.isReachedTarget()) {
                ++this.ticksOnTarget;
                this.bedBug.setBurrowing(true);
            } else {
                this.ticksOnTarget = 0;
            }
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            return BedbugEntity.isValidBedForInfestation(level.getBlockState(pos));
        }

        protected int nextStartTick(PathfinderMob creature) {
            return super.nextStartTick(creature) * 100;
        }

        protected boolean findNearestBlock() {
            if (this.bedBug.targetBed != null && this.isValidTarget((LevelReader)this.mob.level(), this.bedBug.targetBed)) {
                this.blockPos = this.bedBug.targetBed;
                return true;
            }
            List<BlockPos> v = this.findNearestBed();
            if (!v.isEmpty()) {
                this.bedBug.targetBed = v.get(0);
                this.blockPos = v.get(0);
                return true;
            }
            return false;
        }

        private List<BlockPos> findNearestBed() {
            BlockPos pos = this.bedBug.blockPosition();
            ServerLevel level = (ServerLevel)this.bedBug.level();
            PoiManager poiManager = level.getPoiManager();
            Stream stream = poiManager.getInRange(h -> h.is(PoiTypes.HOME), pos, this.searchRange, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::getPos).filter(p -> this.isValidTarget((LevelReader)level, (BlockPos)p)).sorted(Comparator.comparingDouble(p -> p.distSqr((Vec3i)pos))).toList();
        }
    }

    static class BedbugLeapGoal
    extends LeapAtTargetGoal {
        private final Mob mob;

        public BedbugLeapGoal(Mob mob, float f) {
            super(mob, f);
            this.mob = mob;
        }

        public void start() {
            this.mob.getLookControl().setLookAt((Entity)this.mob.getTarget());
            super.start();
        }
    }

    static class BedbugAttackGoal
    extends MeleeAttackGoal {
        private final BedbugEntity bedbug;

        public BedbugAttackGoal(BedbugEntity spider) {
            super((PathfinderMob)spider, 1.0, true);
            this.bedbug = spider;
        }

        public boolean canUse() {
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (this.bedbug.targetBed != null && this.mob.getRandom().nextInt(100) == 0) {
                this.mob.setTarget(null);
                return false;
            }
            return super.canContinueToUse();
        }
    }

    private static class BedbugNavigation
    extends WallClimberNavigation {
        BedbugNavigation(BedbugEntity frog, Level level) {
            super((Mob)frog, level);
        }

        protected PathFinder createPathFinder(int maxVisitedNodes) {
            this.nodeEvaluator = new BedbugNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
        }
    }

    private static class BedbugNodeEvaluator
    extends WalkNodeEvaluator {
        protected double getFloorLevel(BlockPos pos) {
            BlockPos blockPos = pos.below();
            CollisionGetter blockGetter = this.currentContext.level();
            BlockState state = blockGetter.getBlockState(blockPos);
            if (state.is(SleepTight.BEDBUG_WALK_THROUGH)) {
                return blockPos.getY();
            }
            VoxelShape voxelShape = state.getCollisionShape((BlockGetter)blockGetter, blockPos);
            return (double)blockPos.getY() + (voxelShape.isEmpty() ? 0.0 : voxelShape.max(Direction.Axis.Y));
        }

        public Set<PathType> getPathTypeWithinMobBB(PathfindingContext context, int x, int y, int z) {
            EnumSet<PathType> enumSet = EnumSet.noneOf(PathType.class);
            for (int i = 0; i < this.entityWidth; ++i) {
                for (int j = 0; j < this.entityHeight; ++j) {
                    for (int k = 0; k < this.entityDepth; ++k) {
                        int l = i + x;
                        int m = j + y;
                        int n = k + z;
                        PathType pathType = this.getPathType(context, l, m, n);
                        pathType = this.modifyPathType(context, l, m, n, pathType);
                        BlockPos blockPos = this.mob.blockPosition();
                        boolean bl = this.canPassDoors();
                        if (pathType == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && bl) {
                            pathType = PathType.WALKABLE_DOOR;
                        }
                        if (pathType == PathType.DOOR_OPEN && !bl) {
                            pathType = PathType.BLOCKED;
                        }
                        if (pathType == PathType.RAIL && this.getPathType(context, blockPos.getX(), blockPos.getY(), blockPos.getZ()) != PathType.RAIL && this.getPathType(context, blockPos.getX(), blockPos.getY() - 1, blockPos.getZ()) != PathType.RAIL) {
                            pathType = PathType.UNPASSABLE_RAIL;
                        }
                        enumSet.add(pathType);
                    }
                }
            }
            return enumSet;
        }

        protected PathType modifyPathType(PathfindingContext blockGetter, int x, int y, int z, PathType nodeType) {
            if (nodeType == PathType.DOOR_OPEN || nodeType == PathType.DOOR_WOOD_CLOSED || nodeType == PathType.WALKABLE_DOOR) {
                return PathType.OPEN;
            }
            if (nodeType == PathType.BLOCKED && blockGetter.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() instanceof BedBlock) {
                return PathType.WALKABLE;
            }
            return nodeType;
        }
    }
}

