/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.items;

import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BedbugEggsItem
extends Item {
    public BedbugEggsItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOnBed(Player player, InteractionHand hand, ItemStack stack, BlockState state, BlockPos pos, BlockHitResult hit) {
        Level level = player.level();
        if (BedbugEggsItem.infestBed(level, pos, null)) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.playSound(player, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.PLAYERS, 0.6f, 1.7f);
            level.playSound(player, pos, SoundEvents.SILVERFISH_STEP, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level.isClientSide) {
                Vec3 h = hit.getLocation();
                for (int i = 0; i < 8; ++i) {
                    level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getDefaultInstance()), h.x, h.y + 0.1, h.z, ((double)level.random.nextFloat() - 0.5) * 0.08, ((double)level.random.nextFloat() - 0.5) * 0.08, ((double)level.random.nextFloat() - 0.5) * 0.08);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean infestBed(Level level, BlockPos pos, @Nullable BedbugEntity entity) {
        BedData data = STPlatStuff.getBedData(level, pos);
        if (data != null && !data.isInfested()) {
            CompoundTag mobTag;
            if (entity != null) {
                mobTag = BedbugEggsItem.prepareMobTagForContainer((Entity)entity, 0.5);
            } else {
                mobTag = new CompoundTag();
                mobTag.putString("id", SleepTight.BEDBUG_ENTITY.getId().toString());
            }
            data.setBedBug(mobTag);
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile != null) {
                level.sendBlockUpdated(pos, tile.getBlockState(), tile.getBlockState(), 3);
                tile.setChanged();
            }
            return true;
        }
        return false;
    }

    private static CompoundTag prepareMobTagForContainer(Entity entity, double yOffset) {
        double px = 0.5;
        double py = yOffset + 1.0E-4;
        double pz = 0.5;
        entity.setPos(px, py, pz);
        entity.xOld = px;
        entity.yOld = py;
        entity.zOld = pz;
        if (entity.isPassenger()) {
            entity.getVehicle().ejectPassengers();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.yHeadRotO = 0.0f;
            le.yHeadRot = 0.0f;
            le.walkAnimation.setSpeed(0.0f);
            le.hurtDuration = 0;
            le.hurtTime = 0;
            le.attackAnim = 0.0f;
        }
        entity.setYRot(0.0f);
        entity.yRotO = 0.0f;
        entity.xRotO = 0.0f;
        entity.setXRot(0.0f);
        entity.clearFire();
        entity.invulnerableTime = 0;
        CompoundTag mobTag = new CompoundTag();
        entity.save(mobTag);
        if (mobTag.isEmpty()) {
            return null;
        }
        mobTag.remove("Passengers");
        mobTag.remove("Leash");
        mobTag.remove("UUID");
        return mobTag;
    }
}

