/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.items;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class NightBagItem
extends BlockItem {
    public NightBagItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockPos pos = BlockPos.containing((Position)player.position().add(0.0, 0.0625, 0.0));
            ItemStack stack = player.getItemInHand(usedHand);
            Either<Player.BedSleepingProblem, Unit> problem = STPlatStuff.invokeSleepChecksEvents(sp, pos);
            if (problem.left().isPresent()) {
                Component m = ((Player.BedSleepingProblem)problem.left().get()).getMessage();
                if (problem.left().get() == Player.BedSleepingProblem.NOT_POSSIBLE_HERE) {
                    m = Component.translatable((String)"message.sleep_tight.not_possible_here");
                }
                if (m != null) {
                    player.displayClientMessage(m, true);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            BlockHitResult hit = new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 1.0, 0.0), Direction.DOWN, pos, false);
            BlockPlaceContext context = new BlockPlaceContext(player, usedHand, stack, hit);
            InteractionResult r = this.place(context);
            return switch (r) {
                case InteractionResult.SUCCESS -> InteractionResultHolder.consume((Object)stack);
                case InteractionResult.CONSUME, InteractionResult.CONSUME_PARTIAL -> InteractionResultHolder.consume((Object)stack);
                case InteractionResult.FAIL -> {
                    player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.night_bag"), true);
                    yield InteractionResultHolder.fail((Object)stack);
                }
                default -> InteractionResultHolder.pass((Object)stack);
            };
        }
        return super.use(level, player, usedHand);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        return !this.mustSurvive() || state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos());
    }
}

