/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AccelerateHammockMessage
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, AccelerateHammockMessage> TYPE = Message.makeType((ResourceLocation)SleepTight.res("accelerate_hammock"), AccelerateHammockMessage::new);
    private final boolean leftPressed;
    private final BlockPos pos;

    public AccelerateHammockMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.leftPressed = buf.readBoolean();
    }

    public AccelerateHammockMessage(BlockPos pos, boolean leftPressed) {
        this.leftPressed = leftPressed;
        this.pos = pos;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.leftPressed);
    }

    public void handle(Message.Context context) {
        if (context.getDirection() == Message.NetworkDir.CLIENT_BOUND) {
            Level level = Minecraft.getInstance().cameraEntity.level();
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof HammockTile) {
                HammockTile tile = (HammockTile)blockEntity;
                if (this.leftPressed) {
                    tile.accelerateLeft();
                } else {
                    tile.accelerateRight();
                }
            }
        } else {
            Player p = context.getPlayer();
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)p, (CustomPacketPayload)this);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

