/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.tiles;

import net.mehvahdjukaar.moonlight.api.client.anim.PendulumAnimation;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.network.AccelerateHammockMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundFallFromHammockMessage;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class HammockTile
extends BlockEntity {
    private final DyeColor color;
    private boolean accelerateLeft;
    private boolean accelerateRight;
    private float pivotOffset;
    private Direction direction;
    private final PendulumAnimation animation;

    public HammockTile(BlockPos blockPos, BlockState blockState) {
        super(SleepTight.HAMMOCK_TILE.get(), blockPos, blockState);
        this.color = ((HammockBlock)blockState.getBlock()).getColor();
        this.pivotOffset = ((HammockPart)((Object)blockState.getValue(HammockBlock.PART))).getPivotOffset();
        this.direction = (Direction)blockState.getValue((Property)HammockBlock.FACING);
        this.animation = PlatHelper.getPhysicalSide().isClient() ? new PendulumAnimation(ClientConfigs.HAMMOCK_ANIMATION_PARAM, this::getRotationAxis) : null;
    }

    private Vector3f getRotationAxis() {
        return ((Direction)this.getBlockState().getValue((Property)HammockBlock.FACING)).step();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public float getRoll(float partialTicks) {
        if (!ClientConfigs.HAMMOCK_ANIMATION.get().booleanValue()) {
            return 0.0f;
        }
        return this.animation.getAngle(partialTicks);
    }

    public float getPivotOffset() {
        return this.pivotOffset;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public AABB getRenderBoundingBox() {
        return AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition.offset(-3, 0, -3), (BlockPos)this.worldPosition.offset(3, 2, 3));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HammockTile e) {
        if (e.accelerateLeft || e.accelerateRight) {
            double push = ClientConfigs.SWING_FORCE.get();
            e.animation.addImpulse((float)(push * (double)(e.accelerateLeft ? -1 : 1)));
            NetworkHelper.sendToServer((CustomPacketPayload)new AccelerateHammockMessage(pos, e.accelerateLeft));
        }
        e.animation.tick(false);
        if (Mth.abs((float)e.animation.getAngle(0.0f)) > 86.0f && ClientConfigs.HAMMOCK_FALL.get().booleanValue()) {
            for (BedEntity b : e.level.getEntitiesOfClass(BedEntity.class, new AABB(pos))) {
                for (Entity p : b.getPassengers()) {
                    Player pp;
                    if (p instanceof Player && (pp = (Player)p).isLocalPlayer()) {
                        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundFallFromHammockMessage());
                        continue;
                    }
                    return;
                }
            }
        }
        e.pivotOffset = ((HammockPart)((Object)state.getValue(HammockBlock.PART))).getPivotOffset();
        e.direction = (Direction)state.getValue((Property)HammockBlock.FACING);
        e.accelerateLeft = false;
        e.accelerateRight = false;
    }

    public void accelerateLeft() {
        this.accelerateLeft = true;
    }

    public void accelerateRight() {
        this.accelerateRight = true;
    }

    public void addImpulse(float vel) {
        this.animation.addImpulse(vel);
    }
}

