/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.Optional;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WakeUpEncounterHelper {
    public static boolean tryPerformEncounter(ServerPlayer player, ServerLevel level, BlockPos bedPos) {
        if (!level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = bedPos.mutable();
        int monsterSpawnAttempts = CommonConfigs.ENCOUNTER_TRIES.get();
        int maxCount = CommonConfigs.ENCOUNTER_MAX_COUNT.get();
        int max = CommonConfigs.ENCOUNTER_RADIUS.get();
        int min = CommonConfigs.ENCOUNTER_MIN_RADIUS.get();
        int height = CommonConfigs.ENCOUNTER_HEIGHT.get();
        int count = 0;
        StructureManager struct = level.structureManager();
        ChunkGenerator generator = level.getChunkSource().getGenerator();
        MobCategory category = MobCategory.MONSTER;
        int maxAttempts = (int)((float)monsterSpawnAttempts * level.getCurrentDifficultyAt(bedPos).getEffectiveDifficulty());
        for (int attempt = 0; attempt < maxAttempts && count < maxCount; ++attempt) {
            Mob mob;
            Object entity;
            WakeUpEncounterHelper.setRandomPosCyl(bedPos, mutable, level.random, min, max, height);
            Optional<EntityType<?>> spawnData = WakeUpEncounterHelper.getRandomEncounterData(level, struct, generator, category, (BlockPos)mutable);
            if (spawnData.isEmpty() || !((entity = WakeUpEncounterHelper.createValidMobToSpawn(player.position(), level, mutable, spawnData.get(), MobSpawnType.NATURAL)) instanceof Mob) || !(mob = (Mob)entity).hasLineOfSight((Entity)player)) continue;
            WakeUpEncounterHelper.doSpawnMob(level, mob);
            WakeUpEncounterHelper.setupMobToTargetPlayer(player, mob);
            ++count;
        }
        return count != 0;
    }

    private static void doSpawnMob(ServerLevel level, Mob mob) {
        mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.EVENT, null);
        level.addFreshEntityWithPassengers((Entity)mob);
    }

    private static void setRandomPosCircle(BlockPos center, BlockPos.MutableBlockPos mutable, RandomSource random, int min, int max) {
        int l = random.nextInt(min, max);
        Vec3 v = new Vec3((double)l, 0.0, 0.0).yRot(random.nextFloat() * (float)Math.PI * 2.0f).xRot(random.nextFloat() * (float)Math.PI);
        mutable.set((double)center.getX() + 0.5 + v.x, (double)center.getY() + 0.5 + v.y, (double)center.getZ() + 0.5 + v.z);
    }

    private static void setRandomPosCyl(BlockPos center, BlockPos.MutableBlockPos mutable, RandomSource random, int min, int max, int height) {
        int l = random.nextInt(min, max);
        Vec3 v = new Vec3((double)l, (double)height * (random.nextDouble() - 0.5), 0.0).yRot(random.nextFloat() * (float)Math.PI * 2.0f);
        mutable.set((double)center.getX() + 0.5 + v.x, (double)center.getY() + 0.5 + v.y, (double)center.getZ() + 0.5 + v.z);
    }

    @Nullable
    private static <T extends Entity> T createValidMobToSpawn(Vec3 centerPos, ServerLevel level, BlockPos.MutableBlockPos pos, EntityType<T> entityType, MobSpawnType spawnType) {
        if (level.isNaturalSpawningAllowed((BlockPos)pos)) {
            double d = (double)pos.getX() + 0.5;
            double e = (double)pos.getZ() + 0.5;
            double y = pos.getY();
            double f = centerPos.distanceToSqr(d, y, e);
            SpawnPlacementType type = SpawnPlacements.getPlacementType(entityType);
            if (!(SpawnPlacements.isSpawnPositionOk(entityType, (LevelReader)level, (BlockPos)pos) && SpawnPlacements.checkSpawnRules(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)level.random) && level.noCollision(entityType.getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5)))) {
                return null;
            }
            Mob mob = NaturalSpawner.getMobForSpawn((ServerLevel)level, entityType);
            if (mob == null) {
                return null;
            }
            mob.moveTo(d, (double)pos.getY(), e, level.random.nextFloat() * 360.0f, 0.0f);
            if (NaturalSpawner.isValidPositionForMob((ServerLevel)level, (Mob)mob, (double)f)) {
                return (T)mob;
            }
        }
        return null;
    }

    private static void setupMobToTargetPlayer(ServerPlayer player, Mob mob) {
        mob.lookAt((Entity)player, 360.0f, 45.0f);
        mob.yHeadRot = mob.getYRot();
        mob.yHeadRotO = mob.getYRot();
        mob.getLookControl().setLookAt((Entity)player);
        player.stopSleeping();
        player.lookAt(EntityAnchorArgument.Anchor.EYES, (Entity)mob, EntityAnchorArgument.Anchor.EYES);
        mob.setOnGround(true);
        Path path = mob.getNavigation().createPath((Entity)player, 0);
        if (path != null) {
            mob.setTarget((LivingEntity)player);
        }
        mob.playAmbientSound();
    }

    private static Optional<EntityType<?>> getRandomEncounterData(ServerLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory category, BlockPos pos) {
        SimpleWeightedRandomList<EntityType<?>> list = CommonConfigs.ENCOUNTER_WHITELIST.get();
        if (!list.isEmpty()) {
            return list.getRandom(level.random).map(WeightedEntry.Wrapper::data);
        }
        return WeightedRandomList.create(NaturalSpawner.mobsAt((ServerLevel)level, (StructureManager)structureManager, (ChunkGenerator)chunkGenerator, (MobCategory)category, (BlockPos)pos, (Holder)level.getBiome(pos)).unwrap().stream().filter(e -> !e.type.is(SleepTight.WAKE_UP_BLACKLIST)).toList()).getRandom(level.random).map(e -> e.type);
    }

    public static boolean trySpawningBedbug(BlockPos bedPos, ServerPlayer player, BedData data) {
        ServerLevel level = (ServerLevel)player.level();
        if (!level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return false;
        }
        double spawnChance = CommonConfigs.BEDBUG_SPAWN_CHANCE.get();
        if ((double)level.random.nextFloat() < spawnChance) {
            if (CommonConfigs.PREVENTED_BY_DREAM_CATCHER.get().booleanValue() && DreamEssenceBlock.isInRange(bedPos, (Level)level)) {
                return false;
            }
            if (CommonConfigs.ONLY_WHEN_IN_HOME_BED.get().booleanValue()) {
                PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((Player)player);
                if (data == null || !playerData.isBedLastSleptInto(data)) {
                    return false;
                }
            }
            BlockPos.MutableBlockPos mutable = bedPos.mutable();
            int monsterSpawnAttempts = CommonConfigs.BEDBUG_TRIES.get();
            int min = CommonConfigs.BEDBUG_SPAWN_MIN_RANGE.get();
            int max = CommonConfigs.BEDBUG_SPAWN_MAX_RANGE.get();
            int maxAttempts = (int)((float)monsterSpawnAttempts * (1.0f + level.getCurrentDifficultyAt(bedPos).getSpecialMultiplier()));
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                WakeUpEncounterHelper.setRandomPosCircle(bedPos, mutable, level.random, min, max);
                BedbugEntity mob = (BedbugEntity)((Object)WakeUpEncounterHelper.createValidMobToSpawn(Vec3.atCenterOf((Vec3i)mutable), level, mutable, (EntityType)SleepTight.BEDBUG_ENTITY.get(), MobSpawnType.EVENT));
                if (mob == null) continue;
                mob.setOnGround(true);
                Path path = mob.getNavigation().createPath((BlockPos)mutable, 0);
                if (path == null) continue;
                mob.setBedTarget((BlockPos)mutable);
                WakeUpEncounterHelper.doSpawnMob(level, (Mob)mob);
                return true;
            }
        }
        return false;
    }
}

