/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.neoforge;

import com.mojang.datafixers.util.Either;
import java.util.List;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.neoforge.ForgePlayerSleepCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Contract;

public class STPlatStuffImpl {
    @Contract
    public static PlayerSleepData getPlayerSleepData(Player player) {
        return (PlayerSleepData)player.getData(ForgePlayerSleepCapability.SLEEP_ATTACHMENT);
    }

    @Contract
    public static Either<Player.BedSleepingProblem, Unit> invokeSleepChecksEvents(ServerPlayer player, BlockPos bedPos) {
        Either vanillaResult = STPlatStuffImpl.getVanillaSleepChecks((Player)player, bedPos);
        if ((vanillaResult = EventHooks.canPlayerStartSleeping((ServerPlayer)player, (BlockPos)bedPos, vanillaResult)).left().isPresent()) {
            return vanillaResult;
        }
        return Either.right((Object)Unit.INSTANCE);
    }

    @Contract
    public static Either<Player.BedSleepingProblem, Unit> getVanillaSleepChecks(Player player, BlockPos bedPos) {
        if (player.isSleeping() || !player.isAlive()) {
            return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        if (!player.level().dimensionType().natural()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
        }
        if (player.level().isDay()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
        if (!player.isCreative()) {
            Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)bedPos);
            List list = player.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x() - 8.0, vec3.y() - 5.0, vec3.z() - 8.0, vec3.x() + 8.0, vec3.y() + 5.0, vec3.z() + 8.0), argx -> argx.isPreventingPlayerRest(player));
            if (!list.isEmpty()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
            }
        }
        return Either.right((Object)Unit.INSTANCE);
    }
}

