/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.neoforge;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.core.ModEvents;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.neoforge.ForgePlayerSleepCapability;
import net.mehvahdjukaar.sleep_tight.neoforge.SleepTightForgeClient;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerRespawnPositionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@Mod(value="sleep_tight")
public class SleepTightForge {
    public SleepTightForge(IEventBus bus) {
        RegHelper.startRegisteringFor((Object)bus);
        SleepTight.commonInit();
        if (PlatHelper.getPhysicalSide().isClient()) {
            SleepTightClient.init();
            SleepTightForgeClient.init(bus);
        }
        ForgePlayerSleepCapability.init();
        NeoForge.EVENT_BUS.register((Object)this);
        bus.addListener(SleepTightForge::setup);
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(SleepTight::commonSetup);
    }

    @SubscribeEvent
    public void onPlayerRespawnPositionCheck(PlayerRespawnPositionEvent event) {
        DimensionTransition transition = event.getDimensionTransition();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (ModEvents.shouldCancelRespawnHere(event.getEntity(), transition)) {
                event.setDimensionTransition(DimensionTransition.missingRespawnBlock((ServerLevel)sp.server.overworld(), (Entity)sp, (DimensionTransition.PostDimensionTransition)transition.postDimensionTransition()));
            }
        }
    }

    @SubscribeEvent
    public void onSleepConditionCheck(CanPlayerSleepEvent event) {
        if (!ModEvents.checkExtraSleepConditions((Player)event.getEntity(), event.getPos())) {
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        switch (ModEvents.onCheckSleepTime(event.getEntity().level(), event.getPos())) {
            case FAIL: {
                if (event.getVanillaProblem() != null) break;
                event.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
                break;
            }
            case CONSUME: 
            case SUCCESS: {
                if (event.getVanillaProblem() != Player.BedSleepingProblem.NOT_POSSIBLE_NOW) break;
                event.setProblem(null);
            }
        }
    }

    @SubscribeEvent
    public void canContinueSleeping(CanContinueSleepingEvent event) {
        Optional p = event.getEntity().getSleepingPos();
        if (p.isPresent()) {
            switch (ModEvents.onCheckSleepTime(event.getEntity().level(), (BlockPos)p.get())) {
                case FAIL: {
                    event.setContinueSleeping(false);
                    break;
                }
                case CONSUME: 
                case SUCCESS: {
                    event.setContinueSleeping(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        if (!ModEvents.canSetSpawn(evt.getEntity(), evt.getNewSpawn())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            long newTime;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            long oldTime = evt.getNewTime();
            if (oldTime != (newTime = ModEvents.getWakeUpTimeWhenSlept(serverLevel, oldTime))) {
                evt.setTimeAddition(newTime);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        ModEvents.onWokenUp(evt.getEntity(), evt.updateLevel());
    }

    @SubscribeEvent
    public void onSpawnSet(PlayerSetSpawnEvent evt) {
        BlockPos newSpawn;
        if (evt.getSpawnLevel() == evt.getEntity().level().dimension() && (newSpawn = evt.getNewSpawn()) != null && ModEvents.shouldCancelSetSpawn(evt.getEntity(), newSpawn)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onUseBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret;
        if (!event.isCanceled() && (ret = ModEvents.onRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) != null) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModEvents.onPlayerLoggedIn(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player old = event.getOriginal();
        PlayerSleepData oldData = STPlatStuff.getPlayerSleepData(old);
        PlayerSleepData newData = STPlatStuff.getPlayerSleepData(event.getEntity());
        newData.copyFrom(oldData);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModEvents.onPlayerRespawned(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PlayerSleepData sleepData = STPlatStuff.getPlayerSleepData(player);
            sleepData.tick(sp);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ModEvents.onEntityKilled(event.getEntity(), event.getSource().getEntity());
    }

    @SubscribeEvent
    public void onBlockBreak(BlockDropsEvent event) {
        int j;
        int i;
        ServerLevel serverLevel = event.getLevel();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel sl = serverLevel;
            ModEvents.spawnAfterBreakBed(event.getState(), sl, event.getPos(), null);
        }
        if ((i = event.getDroppedExperience()) > 0 && (j = InvigoratedEffect.forgeGetExtraXpForBlockBroken(i, event.getBreaker())) != 0) {
            event.setDroppedExperience(i + j);
        }
    }
}

