/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.class_1267;
import net.minecraft.class_128;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_148;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1944;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6868;
import net.minecraft.class_7;
import net.minecraft.class_7477;
import net.minecraft.class_8710;
import net.minecraft.class_9316;

public class BedbugEntity
extends class_1588 {
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(BedbugEntity.class, (class_2941)class_2943.field_13319);
    private class_2338 targetBed;
    private int burrowingTicks = 0;
    private int prevBurrowingTicks = 0;

    public BedbugEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    public BedbugEntity(class_1937 level) {
        super((class_1299)SleepTight.BEDBUG_ENTITY.get(), level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_6868((class_1308)this, this.method_37908()));
        this.field_6201.method_6277(2, (class_1352)new InfestBedGoal(this, 1.0, 20));
        this.field_6201.method_6277(3, (class_1352)new BedbugLeapGoal((class_1308)this, 0.25f));
        this.field_6201.method_6277(4, (class_1352)new BedbugAttackGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_FLAGS_ID, (Object)0);
    }

    public float getBurrowing(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevBurrowingTicks, (float)this.burrowingTicks);
    }

    public int method_5986() {
        return 0;
    }

    public int method_5978() {
        return 20;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5968() != null) {
            this.method_5988().method_35111((class_1297)this.method_5968());
        }
        class_1937 level = this.method_37908();
        if (!level.field_9236) {
            this.setClimbing(this.field_5976);
        } else {
            this.prevBurrowingTicks = this.burrowingTicks;
        }
        if (this.isBurrowing()) {
            class_2338 pos = this.method_24515();
            class_2680 feetBlockState = level.method_8320(pos);
            if (!(feetBlockState.method_26204() instanceof class_2244)) {
                this.setBurrowing(false);
            } else {
                ++this.burrowingTicks;
                if (level.field_9236) {
                    for (int i = 0; i < 6 + level.field_9229.method_43048(10); ++i) {
                        float x = (float)pos.method_10263() + level.field_9229.method_43057();
                        float z = (float)pos.method_10260() + level.field_9229.method_43057();
                        float y = (float)pos.method_10264() + 0.5625f;
                        level.method_8406((class_2394)new class_2388(class_2398.field_11217, feetBlockState), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                    }
                } else if (this.burrowingTicks > 40) {
                    if (BedbugEggsItem.infestBed(level, pos, this)) {
                        this.method_5990();
                        this.method_31472();
                        level.method_8396(null, pos, class_3417.field_14983, class_3419.field_15251, 1.0f, 1.0f);
                    } else {
                        this.setBurrowing(false);
                    }
                } else if (this.burrowingTicks % 4 == 0) {
                    level.method_8396(null, pos, class_3417.field_14628, class_3419.field_15251, 0.5f, 1.2f);
                }
            }
        } else if (this.burrowingTicks > 0) {
            this.burrowingTicks = Math.max(0, this.burrowingTicks - 4);
        }
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
    }

    protected class_3414 method_5994() {
        return SleepTight.BEDBUG_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return SleepTight.BEDBUG_HURT.get();
    }

    protected class_3414 method_6002() {
        return SleepTight.BEDBUG_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_15084, 0.15f, 1.0f);
    }

    public boolean method_6101() {
        return this.isClimbing();
    }

    public void method_5844(class_2680 state, class_243 motionMultiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, motionMultiplier);
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public boolean isSplattered() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 3) != 0;
    }

    public boolean isBurrowing() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 5) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)b);
    }

    public void setSplattered(boolean splattered) {
        byte b = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        b = splattered ? (byte)(b | 3) : (byte)(b & 0xFFFFFFFD);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)b);
    }

    public void setBurrowing(boolean burrowing) {
        byte b = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        b = burrowing ? (byte)(b | 5) : (byte)(b & 0xFFFFFFFB);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)b);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new BedbugNavigation(this, level);
    }

    public void setBedTarget(class_2338 pos) {
        this.targetBed = new class_2338((class_2382)pos);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("targetBed")) {
            this.targetBed = class_2512.method_10691((class_2487)compound, (String)"targetBed").orElse(null);
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.targetBed != null) {
            compound.method_10566("targetBed", class_2512.method_10692((class_2338)this.targetBed));
        }
    }

    protected void onInsideBlock(class_2680 state, class_2338 pos) {
        class_265 voxelShape;
        class_265 voxelShape2;
        if (state.method_26204() instanceof class_2323 && class_259.method_1074((class_265)(voxelShape2 = (voxelShape = state.method_26220((class_1922)this.method_37908(), pos)).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())), (class_265)class_259.method_1078((class_238)this.method_5829()), (class_247)class_247.field_16896)) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((class_1297)this, (class_8710)ClientBoundParticleMessage.bedbugDoor(pos));
            this.method_5844(state, new class_243(0.5, 0.5, 0.5));
        }
        super.method_5622(state);
    }

    protected void method_5852() {
        class_238 aABB = this.method_5829();
        class_2338 blockPos = class_2338.method_49637((double)(aABB.field_1323 + 0.001), (double)(aABB.field_1322 + 0.001), (double)(aABB.field_1321 + 0.001));
        class_2338 blockPos2 = class_2338.method_49637((double)(aABB.field_1320 - 0.001), (double)(aABB.field_1325 - 0.001), (double)(aABB.field_1324 - 0.001));
        class_1937 level = this.method_37908();
        if (level.method_22343(blockPos, blockPos2)) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                        mutableBlockPos.method_10103(i, j, k);
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                        try {
                            blockState.method_26178(level, (class_2338)mutableBlockPos, (class_1297)this);
                            this.onInsideBlock(blockState, (class_2338)mutableBlockPos);
                            continue;
                        }
                        catch (Exception e) {
                            class_128 crashReport = class_128.method_560((Throwable)e, (String)"Colliding entity with block");
                            class_129 crashReportCategory = crashReport.method_562("Block being collided with");
                            class_129.method_586((class_129)crashReportCategory, (class_5539)level, (class_2338)mutableBlockPos, (class_2680)blockState);
                            throw new class_148(crashReport);
                        }
                    }
                }
            }
        }
    }

    public boolean method_30949(class_1297 entity) {
        return super.method_30949(entity);
    }

    public boolean method_30632(class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof class_2323) {
            return false;
        }
        return super.method_30632(pos, state);
    }

    public static boolean isValidBedForInfestation(class_2680 state) {
        class_2248 block = state.method_26204();
        return block instanceof class_2244 && (Boolean)state.method_11654((class_2769)class_2244.field_9968) == false;
    }

    public static class_5132.class_5133 makeAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 9.0).method_26868(class_5134.field_23719, 0.325).method_26868(class_5134.field_23721, 1.0);
    }

    public static boolean checkMonsterSpawnRules(class_1299<? extends class_1588> type, class_5425 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        if (spawnType == class_3730.field_16467 && level.method_8407() != class_1267.field_5801) {
            int maxLight = CommonConfigs.BEDBUG_MAX_LIGHT.get();
            if (maxLight < 15) {
                int light = Math.max(level.method_8314(class_1944.field_9282, pos), level.method_8314(class_1944.field_9284, pos));
                return light <= maxLight;
            }
            return true;
        }
        return class_1588.method_20680(type, (class_5425)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random);
    }

    static class InfestBedGoal
    extends class_1367 {
        private final List<class_2338> blacklist = new ArrayList<class_2338>();
        private final BedbugEntity bedBug;
        private final int searchRange;
        private int ticksOnTarget = 0;
        private boolean reachedTarget;

        public InfestBedGoal(BedbugEntity pathfinderMob, double speed, int searchRange) {
            super((class_1314)pathfinderMob, speed, searchRange);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407, class_1352.class_4134.field_18406, class_1352.class_4134.field_18408));
            this.bedBug = pathfinderMob;
            this.searchRange = searchRange;
        }

        protected boolean method_6295() {
            return this.reachedTarget;
        }

        protected class_2338 method_30953() {
            return this.field_6512;
        }

        public void method_6268() {
            class_2338 blockPos = this.method_30953();
            double dist = blockPos.method_19770((class_2374)this.field_6516.method_19538());
            if (dist >= 1.0) {
                this.reachedTarget = false;
                ++this.field_6517;
                if (this.method_6294()) {
                    double s = this.field_6514;
                    if (dist < 2.25) {
                        s /= 2.0;
                    }
                    this.field_6516.method_5942().method_6337((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.25, (double)blockPos.method_10260() + 0.5, s);
                }
            } else {
                this.reachedTarget = true;
                --this.field_6517;
            }
            if (this.method_6295()) {
                ++this.ticksOnTarget;
                this.bedBug.setBurrowing(true);
            } else {
                this.ticksOnTarget = 0;
            }
        }

        protected boolean method_6296(class_4538 level, class_2338 pos) {
            return BedbugEntity.isValidBedForInfestation(level.method_8320(pos));
        }

        protected int method_6293(class_1314 creature) {
            return super.method_6293(creature) * 100;
        }

        protected boolean method_6292() {
            if (this.bedBug.targetBed != null && this.method_6296((class_4538)this.field_6516.method_37908(), this.bedBug.targetBed)) {
                this.field_6512 = this.bedBug.targetBed;
                return true;
            }
            List<class_2338> v = this.findNearestBed();
            if (!v.isEmpty()) {
                this.bedBug.targetBed = v.get(0);
                this.field_6512 = v.get(0);
                return true;
            }
            return false;
        }

        private List<class_2338> findNearestBed() {
            class_2338 pos = this.bedBug.method_24515();
            class_3218 level = (class_3218)this.bedBug.method_37908();
            class_4153 poiManager = level.method_19494();
            Stream stream = poiManager.method_19125(h -> h.method_40225(class_7477.field_39291), pos, this.searchRange, class_4153.class_4155.field_18489);
            return stream.map(class_4156::method_19141).filter(p -> this.method_6296((class_4538)level, (class_2338)p)).sorted(Comparator.comparingDouble(p -> p.method_10262((class_2382)pos))).toList();
        }
    }

    static class BedbugLeapGoal
    extends class_1359 {
        private final class_1308 mob;

        public BedbugLeapGoal(class_1308 mob, float f) {
            super(mob, f);
            this.mob = mob;
        }

        public void method_6269() {
            this.mob.method_5988().method_35111((class_1297)this.mob.method_5968());
            super.method_6269();
        }
    }

    static class BedbugAttackGoal
    extends class_1366 {
        private final BedbugEntity bedbug;

        public BedbugAttackGoal(BedbugEntity spider) {
            super((class_1314)spider, 1.0, true);
            this.bedbug = spider;
        }

        public boolean method_6264() {
            return super.method_6264();
        }

        public boolean method_6266() {
            if (this.bedbug.targetBed != null && this.field_6503.method_59922().method_43048(100) == 0) {
                this.field_6503.method_5980(null);
                return false;
            }
            return super.method_6266();
        }
    }

    private static class BedbugNavigation
    extends class_1410 {
        BedbugNavigation(BedbugEntity frog, class_1937 level) {
            super((class_1308)frog, level);
        }

        protected class_13 method_6336(int maxVisitedNodes) {
            this.field_6678 = new BedbugNodeEvaluator();
            this.field_6678.method_15(true);
            return new class_13(this.field_6678, maxVisitedNodes);
        }
    }

    private static class BedbugNodeEvaluator
    extends class_14 {
        protected double method_37003(class_2338 pos) {
            class_2338 blockPos = pos.method_10074();
            class_1941 blockGetter = this.field_49416.method_57621();
            class_2680 state = blockGetter.method_8320(blockPos);
            if (state.method_26164(SleepTight.BEDBUG_WALK_THROUGH)) {
                return blockPos.method_10264();
            }
            class_265 voxelShape = state.method_26220((class_1922)blockGetter, blockPos);
            return (double)blockPos.method_10264() + (voxelShape.method_1110() ? 0.0 : voxelShape.method_1105(class_2350.class_2351.field_11052));
        }

        public Set<class_7> method_57090(class_9316 context, int x, int y, int z) {
            EnumSet<class_7> enumSet = EnumSet.noneOf(class_7.class);
            for (int i = 0; i < this.field_31; ++i) {
                for (int j = 0; j < this.field_30; ++j) {
                    for (int k = 0; k < this.field_28; ++k) {
                        int l = i + x;
                        int m = j + y;
                        int n = k + z;
                        class_7 pathType = this.method_17(context, l, m, n);
                        pathType = this.modifyPathType(context, l, m, n, pathType);
                        class_2338 blockPos = this.field_33.method_24515();
                        boolean bl = this.method_23();
                        if (pathType == class_7.field_23 && this.method_24() && bl) {
                            pathType = class_7.field_26446;
                        }
                        if (pathType == class_7.field_15 && !bl) {
                            pathType = class_7.field_22;
                        }
                        if (pathType == class_7.field_21 && this.method_17(context, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) != class_7.field_21 && this.method_17(context, blockPos.method_10263(), blockPos.method_10264() - 1, blockPos.method_10260()) != class_7.field_21) {
                            pathType = class_7.field_25418;
                        }
                        enumSet.add(pathType);
                    }
                }
            }
            return enumSet;
        }

        protected class_7 modifyPathType(class_9316 blockGetter, int x, int y, int z, class_7 nodeType) {
            if (nodeType == class_7.field_15 || nodeType == class_7.field_23 || nodeType == class_7.field_26446) {
                return class_7.field_7;
            }
            if (nodeType == class_7.field_22 && blockGetter.method_57623(class_2338.method_49637((double)x, (double)y, (double)z)).method_26204() instanceof class_2244) {
                return class_7.field_12;
            }
            return nodeType;
        }
    }
}

