/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class BedData {
    public static final class_2960 ID = SleepTight.res("bed_data");
    public static final Codec<BedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_41525.fieldOf("id").forGetter(BedData::getId), (App)Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.BYTE).optionalFieldOf("bed_level").forGetter(d -> d.bedLevel.isEmpty() ? Optional.empty() : Optional.of(d.bedLevel)), (App)class_2487.field_25128.optionalFieldOf("bed_bug").forGetter(d -> Optional.ofNullable(d.bedBug))).apply((Applicative)instance, BedData::new));
    private static final class_9139<class_9129, Map<UUID, Byte>> BED_LEVEL_STREAM_CODEC = class_9135.method_56377(i -> new HashMap(), (class_9139)class_4844.field_48453, (class_9139)class_9135.field_48548);
    public static final class_9139<class_9129, BedData> STREAM_CODEC = class_9139.method_56436((class_9139)class_4844.field_48453, BedData::getId, BED_LEVEL_STREAM_CODEC, BedData::getBedLevels, (class_9139)class_9135.field_48547, d -> d.bedBug != null, BedData::ofClient);
    protected UUID id;
    protected Map<UUID, Byte> bedLevel;
    @Nullable
    protected class_2487 bedBug;

    private BedData(UUID id, Optional<Map<UUID, Byte>> homeBedTo, Optional<class_2487> bedBug) {
        this.id = id;
        this.bedLevel = new HashMap<UUID, Byte>(homeBedTo.orElse(Collections.emptyMap()));
        this.bedBug = bedBug.orElse(null);
    }

    public static BedData initializeWithRandomId() {
        return new BedData(UUID.randomUUID(), Optional.empty(), Optional.empty());
    }

    private static BedData ofClient(UUID uuid, Map<UUID, Byte> levels, Boolean aBoolean) {
        return new BedData(uuid, Optional.of(levels), aBoolean != false ? Optional.of(new class_2487()) : Optional.empty());
    }

    public void incrementBedLevel(class_1657 player) {
        UUID playerId = player.method_5667();
        byte value = (byte)Math.min(CommonConfigs.HOME_BED_MAX_LEVEL.get(), this.bedLevel.getOrDefault(playerId, (byte)0) + 1);
        this.bedLevel.put(playerId, value);
    }

    public byte getBedLevel(class_1657 player) {
        return this.bedLevel.getOrDefault(player.method_5667(), (byte)0);
    }

    public Map<UUID, Byte> getBedLevels() {
        return Collections.unmodifiableMap(this.bedLevel);
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isInfested() {
        return this.bedBug != null;
    }

    public void setBedBug(@Nullable class_2487 entityTag) {
        this.bedBug = entityTag;
    }

    public class_2487 getBedBug() {
        return this.bedBug;
    }

    public String toString() {
        return "BedData[id=" + String.valueOf(this.id) + ", bedBug=" + (this.bedBug != null ? "present" : "null") + ", bedLevel=" + String.valueOf(this.bedLevel) + "]";
    }
}

