/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import destiny.armoryofdestiny.server.block.blockentity.ArmorersAnvilBlockEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ArmorersAnvilRenderer
implements BlockEntityRenderer<ArmorersAnvilBlockEntity> {
    public ArmorersAnvilRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(ArmorersAnvilBlockEntity anvil, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)anvil.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        Level level = anvil.m_58904_();
        List<ItemStack> storedItems = anvil.getAllStoredItems();
        Random random = new Random();
        List<Integer> randomRotationList = anvil.randomRotationList;
        if (anvil.getStoredItemAmount() > 0) {
            double itemWidth = 0.03;
            double blockWidth = 0.25;
            double totalWidth = 0.0;
            for (int i = 0; i < storedItems.size(); ++i) {
                ItemStack storedItem = storedItems.get(i);
                poseStack.m_85836_();
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                boolean isBlockItem = itemRenderer.m_174264_(storedItem, level, null, 0).applyTransform(ItemDisplayContext.FIXED, poseStack, false).m_7539_();
                poseStack.m_85849_();
                if (randomRotationList.isEmpty() || randomRotationList.size() <= i) {
                    randomRotationList.add(random.nextInt(-45, 45));
                }
                if (isBlockItem) {
                    this.renderLyingBlock(level, poseStack, storedItem, bufferIn, combinedLightIn, direction, anvil, totalWidth, randomRotationList.get(i));
                    totalWidth += blockWidth;
                    continue;
                }
                this.renderLyingItem(level, poseStack, storedItem, bufferIn, combinedLightIn, direction, anvil, totalWidth, randomRotationList.get(i));
                totalWidth += itemWidth;
            }
        }
        if (randomRotationList.size() > storedItems.size()) {
            for (int i = 0; i < randomRotationList.size() - storedItems.size(); ++i) {
                randomRotationList.remove(randomRotationList.size() - 1);
            }
        }
        if (!anvil.getTongs().m_41619_()) {
            ItemStack tongs = anvil.getTongs();
            this.renderHungTongs(level, poseStack, tongs, bufferIn, combinedLightIn, direction, anvil);
        }
    }

    private void renderLyingItem(Level level, PoseStack poseStack, ItemStack stack, MultiBufferSource bufferIn, int combinedLightIn, Direction direction, ArmorersAnvilBlockEntity anvil, double offset, int randomRotation) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        if (direction == Direction.NORTH) {
            poseStack.m_85837_(0.5, 1.025 + offset, 0.375);
        } else if (direction == Direction.SOUTH) {
            poseStack.m_85837_(0.5, 1.025 + offset, 0.625);
        } else if (direction == Direction.WEST) {
            poseStack.m_85837_(0.375, 1.025 + offset, 0.5);
        } else {
            poseStack.m_85837_(0.625, 1.025 + offset, 0.5);
        }
        float f = -direction.m_122435_() + (float)randomRotation;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }

    private void renderLyingBlock(Level level, PoseStack poseStack, ItemStack stack, MultiBufferSource bufferIn, int combinedLightIn, Direction direction, ArmorersAnvilBlockEntity anvil, double offset, int randomRotation) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.95 + offset, 0.5);
        float f = -direction.m_122435_() + (float)randomRotation;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }

    private void renderHungTongs(Level level, PoseStack poseStack, ItemStack tongs, MultiBufferSource bufferIn, int combinedLightIn, Direction direction, ArmorersAnvilBlockEntity anvil) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        if (direction == Direction.NORTH) {
            poseStack.m_85837_(0.4325, 0.65, 0.15);
        } else if (direction == Direction.SOUTH) {
            poseStack.m_85837_(0.5675, 0.65, 0.85);
        } else if (direction == Direction.WEST) {
            poseStack.m_85837_(0.15, 0.65, 0.4325);
        } else {
            poseStack.m_85837_(0.85, 0.65, 0.5675);
        }
        float f = direction.m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(tongs, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }
}

