/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.block.blockentity;

import destiny.armoryofdestiny.server.container.SmithingContainer;
import destiny.armoryofdestiny.server.recipe.SmithingRecipe;
import destiny.armoryofdestiny.server.recipe.TinkeringRecipe;
import destiny.armoryofdestiny.server.registry.BlockEntityRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ArmorersAnvilBlockEntity
extends BlockEntity {
    private static final String STORED_ITEMS = "stored_items";
    private static final String HAMMER_HITS = "hammer_hits";
    private static final String BLUEPRINT = "blueprint";
    private static final String TONGS_SLOT = "tongs_slot";
    private static final String RANDOM_ROTATION = "random_rotation";
    private final List<ItemStack> storedItems = new ArrayList<ItemStack>();
    private int hammer_hits = -1;
    private ItemStack blueprint = ItemStack.f_41583_;
    private ItemStack tongs_slot = ItemStack.f_41583_;
    public List<Integer> randomRotationList = new ArrayList<Integer>();

    public ArmorersAnvilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.ARMORERS_ANVIL.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ArmorersAnvilBlockEntity anvil) {
        if (level.m_5776_()) {
            return;
        }
    }

    public boolean advanceCrafting(Level level, BlockPos pos, Player player) {
        if (!this.blueprint.m_41619_() && this.blueprint.m_41783_() != null && this.blueprint.m_41783_().m_128423_("recipe") != null) {
            Object t;
            Object t2;
            ResourceLocation recipeID = new ResourceLocation(this.blueprint.m_41784_().m_128461_("recipe"));
            TinkeringRecipe tinkeringRecipe = null;
            Optional optionalRecipeTinkering = level.m_7465_().m_44043_(recipeID);
            if (optionalRecipeTinkering.isPresent() && (t2 = optionalRecipeTinkering.get()) instanceof TinkeringRecipe) {
                TinkeringRecipe recipe;
                tinkeringRecipe = recipe = (TinkeringRecipe)t2;
            }
            if (tinkeringRecipe == null) {
                return false;
            }
            SmithingContainer container = new SmithingContainer(this.storedItems, 0);
            SmithingRecipe craftingRecipe = null;
            Optional optionalRecipe = level.m_7465_().m_44015_((RecipeType)SmithingRecipe.Type.INSTANCE, (Container)container, level);
            if (optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof SmithingRecipe) {
                SmithingRecipe recipe;
                craftingRecipe = recipe = (SmithingRecipe)t;
            }
            if (craftingRecipe == null) {
                return false;
            }
            if (tinkeringRecipe.getResult().m_41720_() == craftingRecipe.getParentItem().m_41720_() && craftingRecipe.matches(container, level)) {
                if (this.hammer_hits == -1) {
                    this.hammer_hits = craftingRecipe.getHammerHits() - 2;
                    level.m_5594_(null, pos, (SoundEvent)SoundRegistry.ARMORERS_ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (this.hammer_hits == 0) {
                    this.storedItems.clear();
                    this.storedItems.add(craftingRecipe.getResult());
                    this.hammer_hits = -1;
                    level.m_5594_(null, pos, (SoundEvent)SoundRegistry.ARMORERS_ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(null, pos, SoundEvents.f_12471_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    --this.hammer_hits;
                    level.m_5594_(null, pos, (SoundEvent)SoundRegistry.ARMORERS_ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.doHammerStuff(player, pos, player.m_21120_(InteractionHand.MAIN_HAND));
                return true;
            }
        } else {
            Object t;
            SmithingContainer container = new SmithingContainer(this.storedItems, 0);
            SmithingRecipe craftingRecipe = null;
            Optional optionalRecipe = level.m_7465_().m_44015_((RecipeType)SmithingRecipe.Type.INSTANCE, (Container)container, level);
            if (optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof SmithingRecipe) {
                SmithingRecipe smithingRecipe;
                craftingRecipe = smithingRecipe = (SmithingRecipe)t;
            }
            if (craftingRecipe == null) {
                return false;
            }
            if (craftingRecipe.getParentItem().m_41619_() && craftingRecipe.matches(container, level)) {
                if (this.hammer_hits == -1) {
                    this.hammer_hits = craftingRecipe.getHammerHits() - 1;
                    level.m_5594_(null, pos, (SoundEvent)SoundRegistry.ARMORERS_ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (this.hammer_hits == 0) {
                    this.storedItems.clear();
                    this.storedItems.add(craftingRecipe.assemble(container, level.m_9598_()));
                    this.hammer_hits = -1;
                    level.m_5594_(null, pos, (SoundEvent)SoundRegistry.ARMORERS_ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(null, pos, SoundEvents.f_12471_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    --this.hammer_hits;
                    level.m_5594_(null, pos, (SoundEvent)SoundRegistry.ARMORERS_ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.doHammerStuff(player, pos, player.m_21120_(InteractionHand.MAIN_HAND));
                return true;
            }
        }
        return false;
    }

    public void doHammerStuff(Player player, BlockPos pos, ItemStack heldItem) {
        Level level;
        if (!player.m_7500_()) {
            heldItem.m_41721_(heldItem.m_41773_() + 1);
            player.m_36335_().m_41524_(heldItem.m_41720_(), 20);
        }
        if ((level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 8, 0.2, 0.1, 0.2, 0.05);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 8, 0.2, 0.1, 0.2, 0.05);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 8, 0.2, 0.1, 0.2, 0.05);
        }
    }

    public void setTongs(ItemStack stack) {
        this.tongs_slot = stack.m_41777_();
    }

    public ItemStack getTongs() {
        return this.tongs_slot.m_41777_();
    }

    public ItemStack getBlueprint() {
        return this.blueprint.m_41777_();
    }

    public void setBlueprint(ItemStack blueprint) {
        this.blueprint = blueprint.m_41777_();
    }

    public int getStoredItemAmount() {
        return this.storedItems.size();
    }

    public List<ItemStack> getAllStoredItems() {
        return this.storedItems;
    }

    public void addStoredItem(ItemStack stack) {
        this.storedItems.add(stack.m_41777_());
    }

    public void removeLastStoredItem() {
        this.storedItems.remove(this.storedItems.size() - 1);
    }

    public ItemStack getLastStoredItem() {
        return this.storedItems.get(this.storedItems.size() - 1);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag storedItemsTag = tag.m_128437_(STORED_ITEMS, 10);
        storedItemsTag.forEach(compound -> {
            CompoundTag compoundTag = (CompoundTag)compound;
            ItemStack storedStack = ItemStack.m_41712_((CompoundTag)compoundTag);
            this.storedItems.add(storedStack);
        });
        this.hammer_hits = tag.m_128451_(HAMMER_HITS);
        this.blueprint = ItemStack.m_41712_((CompoundTag)tag.m_128469_(BLUEPRINT));
        this.tongs_slot = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TONGS_SLOT));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag storedItemsTag = new ListTag();
        for (ItemStack stack : this.storedItems) {
            storedItemsTag.add((Object)stack.serializeNBT());
        }
        tag.m_128365_(STORED_ITEMS, (Tag)storedItemsTag);
        tag.m_128405_(HAMMER_HITS, this.hammer_hits);
        tag.m_128365_(BLUEPRINT, (Tag)this.blueprint.serializeNBT());
        tag.m_128365_(TONGS_SLOT, (Tag)this.tongs_slot.serializeNBT());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        drops.addAll(this.storedItems);
        drops.add((Object)this.blueprint);
        drops.add((Object)this.tongs_slot);
        return drops;
    }

    private void markUpdated() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

