/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.block.blockentity;

import com.mojang.logging.LogUtils;
import destiny.armoryofdestiny.server.block.ArmorersTinkeringTableBlock;
import destiny.armoryofdestiny.server.container.TinkeringContainer;
import destiny.armoryofdestiny.server.recipe.TinkeringRecipe;
import destiny.armoryofdestiny.server.registry.BlockEntityRegistry;
import destiny.armoryofdestiny.server.registry.BlockRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ArmorersTinkeringTableBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String STORED_ITEMS = "stored_items";
    private static final String BLUEPRINT = "blueprint";
    private static final String INPUT = "input";
    private static final String HAMMER = "hammer";
    private final List<ItemStack> storedItems = new ArrayList<ItemStack>();
    private ItemStack blueprint = ItemStack.f_41583_;
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack hammer = ItemStack.f_41583_;
    private Ingredient desired = Ingredient.f_43901_;
    private TinkeringRecipe craftingRecipe = null;
    public ItemStack wantStack = ItemStack.f_41583_;

    public ArmorersTinkeringTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.ARMORERS_TINKERING_TABLE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ArmorersTinkeringTableBlockEntity table) {
        TinkeringContainer container;
        Random random = new Random();
        if (level.m_5776_() || !table.hasBlueprint() || !table.isSmithingCraftingTablePresent()) {
            return;
        }
        if (table.craftingRecipe != null && table.craftingRecipe.matches(container = new TinkeringContainer(table.storedItems), level)) {
            table.input = table.craftingRecipe.assemble(container, level.m_9598_());
            table.storedItems.clear();
            table.setDesired(Ingredient.f_43901_);
            table.setBlueprintItem(ItemStack.f_41583_);
            level.m_46597_(pos, (BlockState)table.m_58900_().m_61124_((Property)ArmorersTinkeringTableBlock.HAS_BLUEPRINT, (Comparable)Boolean.valueOf(false)));
            level.m_5594_(null, pos, SoundEvents.f_12471_, SoundSource.BLOCKS, 0.5f, 1.0f);
            table.markUpdated();
        }
        if (table.craftingRecipe == null) {
            Object t;
            ResourceLocation recipeID = table.getRecipe();
            if (recipeID == null) {
                return;
            }
            Optional optionalRecipe = level.m_7465_().m_44043_(recipeID);
            if (optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof TinkeringRecipe) {
                TinkeringRecipe recipe;
                table.craftingRecipe = recipe = (TinkeringRecipe)t;
            }
        } else if (table.desired == Ingredient.f_43901_) {
            ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>(table.craftingRecipe.getIngredientList());
            ArrayList<ItemStack> storedList = new ArrayList<ItemStack>(table.storedItems);
            Iterator ingredientCopy = ingredientList.iterator();
            block0: while (ingredientCopy.hasNext()) {
                Ingredient ingredient = (Ingredient)ingredientCopy.next();
                for (ItemStack storedItem : storedList) {
                    if (!ingredient.test(storedItem)) continue;
                    ingredientCopy.remove();
                    storedList.remove(storedItem);
                    continue block0;
                }
            }
            if (!ingredientList.isEmpty()) {
                table.setDesired((Ingredient)ingredientList.get(random.nextInt(ingredientList.size())));
            }
        }
    }

    public void advanceCrafting(Level level, BlockPos pos, Player player, ItemStack heldItem) {
        TinkeringContainer container;
        if (level.f_46443_ || !this.isSmithingCraftingTablePresent() || this.craftingRecipe == null) {
            return;
        }
        if (this.desired.test(this.getInputItem())) {
            this.setDesired(Ingredient.f_43901_);
            this.storedItems.add(this.getInputItem());
            this.input = ItemStack.f_41583_;
            this.doHammerStuff(player, pos, heldItem);
        }
        if (this.craftingRecipe.matches(container = new TinkeringContainer(this.storedItems), level)) {
            this.input = this.craftingRecipe.assemble(container, level.m_9598_());
            this.setBlueprintItem(ItemStack.f_41583_);
            this.clearTable();
            this.doHammerStuff(player, pos, heldItem);
            level.m_46597_(pos, (BlockState)this.m_58900_().m_61124_((Property)ArmorersTinkeringTableBlock.HAS_BLUEPRINT, (Comparable)Boolean.valueOf(false)));
            level.m_5594_(null, pos, SoundEvents.f_12471_, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.markUpdated();
        }
    }

    public void clearTable() {
        this.setDesired(Ingredient.f_43901_);
        this.storedItems.clear();
        this.craftingRecipe = null;
    }

    public void doHammerStuff(Player player, BlockPos pos, ItemStack heldItem) {
        Level level;
        if (!player.m_7500_()) {
            heldItem.m_41721_(heldItem.m_41773_() + 1);
        }
        if ((level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 8, 0.2, 0.1, 0.2, 0.05);
        }
        this.f_58857_.m_5594_(null, pos, (SoundEvent)SoundRegistry.SMITHING_HAMMER_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public ItemStack getInputItem() {
        return this.input;
    }

    public void setInputItem(ItemStack stack) {
        this.input = stack.m_41777_();
    }

    public ItemStack getBlueprintItem() {
        return this.blueprint;
    }

    public void setBlueprintItem(ItemStack stack) {
        this.blueprint = stack.m_41777_();
    }

    public ItemStack getHammerSlot() {
        return this.hammer;
    }

    public void setHammerSlot(ItemStack stack) {
        this.hammer = stack.m_41777_();
    }

    public boolean hasBlueprint() {
        return !this.getBlueprintItem().m_41619_();
    }

    public void setDesired(Ingredient ingredient) {
        this.desired = ingredient;
        this.wantStack = ingredient.m_43947_() ? ItemStack.f_41583_ : ingredient.m_43908_()[0];
        this.markUpdated();
    }

    @Nullable
    public ResourceLocation getRecipe() {
        ItemStack blueprint = this.getBlueprintItem();
        if (blueprint.m_41783_() != null) {
            return new ResourceLocation(blueprint.m_41784_().m_128461_("recipe"));
        }
        return null;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag storedItemsTag = tag.m_128437_(STORED_ITEMS, 10);
        storedItemsTag.forEach(compound -> {
            CompoundTag compoundTag = (CompoundTag)compound;
            ItemStack storedStack = ItemStack.m_41712_((CompoundTag)compoundTag);
            this.storedItems.add(storedStack);
        });
        this.blueprint = ItemStack.m_41712_((CompoundTag)tag.m_128469_(BLUEPRINT));
        this.input = ItemStack.m_41712_((CompoundTag)tag.m_128469_(INPUT));
        this.hammer = ItemStack.m_41712_((CompoundTag)tag.m_128469_(HAMMER));
        this.wantStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("want_item"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag storedItemsTag = new ListTag();
        for (ItemStack stack : this.storedItems) {
            storedItemsTag.add((Object)stack.serializeNBT());
        }
        tag.m_128365_(STORED_ITEMS, (Tag)storedItemsTag);
        tag.m_128365_(BLUEPRINT, (Tag)this.blueprint.serializeNBT());
        tag.m_128365_(INPUT, (Tag)this.input.serializeNBT());
        tag.m_128365_(HAMMER, (Tag)this.hammer.serializeNBT());
        tag.m_128365_("want_item", (Tag)this.wantStack.serializeNBT());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isSmithingCraftingTablePresent() {
        if (this.f_58857_ != null) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            BlockPos pos = this.f_58858_.m_121945_(facing.m_122427_());
            pos.m_122013_(1);
            return this.f_58857_.m_8055_(pos).m_60734_() == BlockRegistry.ARMORERS_CRAFTING_TABLE.get() && facing == this.f_58857_.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return false;
    }

    public Ingredient getDesiredItem() {
        return this.desired;
    }

    public ItemStack getWantStack() {
        return this.wantStack;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        drops.addAll(this.storedItems);
        drops.add((Object)this.blueprint);
        drops.add((Object)this.input);
        return drops;
    }

    public NonNullList<ItemStack> getDroppableInventoryWithHammer() {
        NonNullList<ItemStack> drops = this.getDroppableInventory();
        drops.add((Object)this.getHammerSlot());
        return drops;
    }

    private void markUpdated() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

