/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.block.blockentity;

import destiny.armoryofdestiny.server.block.NetherBloomeryBottomBlock;
import destiny.armoryofdestiny.server.registry.BlockEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NetherBloomeryBottomBlockEntity
extends BlockEntity {
    private static final String STORED_LOGS = "stored_logs";
    private static final String BURN_TICK = "burn_tick";
    private final List<ItemStack> logs = new ArrayList<ItemStack>(4);
    private int burnTick = 0;
    private final int burnTimePerLog = 1200;

    public NetherBloomeryBottomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.NETHER_BLOOMERY_BOTTOM.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NetherBloomeryBottomBlockEntity bloomery) {
        if (level.m_5776_()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)NetherBloomeryBottomBlock.LIT)).booleanValue()) {
            if (bloomery.burnTick == 0) {
                if (!bloomery.logs.isEmpty()) {
                    level.m_5594_(null, pos, SoundEvents.f_11701_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    bloomery.burnTick = bloomery.burnTimePerLog;
                    bloomery.logs.remove(bloomery.logs.size() - 1);
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)NetherBloomeryBottomBlock.LOGS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)NetherBloomeryBottomBlock.LOGS) - 1)));
                } else {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)NetherBloomeryBottomBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                --bloomery.burnTick;
            }
        }
    }

    public void setBurnTick(int burnTick) {
        this.burnTick = burnTick;
    }

    public ItemStack takeLog() {
        ItemStack log = this.logs.get(this.logs.size() - 1).m_41777_();
        log.m_41764_(1);
        this.logs.remove(this.logs.size() - 1);
        return log;
    }

    public void putLog(ItemStack log) {
        log.m_41764_(1);
        this.logs.add(log);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag logsTag = tag.m_128437_(STORED_LOGS, 10);
        logsTag.forEach(compound -> {
            CompoundTag compoundTag = (CompoundTag)compound;
            ItemStack logStack = ItemStack.m_41712_((CompoundTag)compoundTag);
            this.logs.add(logStack);
        });
        this.burnTick = tag.m_128451_(BURN_TICK);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag logsTag = new ListTag();
        for (ItemStack stack : this.logs) {
            logsTag.add((Object)stack.serializeNBT());
        }
        tag.m_128365_(STORED_LOGS, (Tag)logsTag);
        tag.m_128405_(BURN_TICK, this.burnTick);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        drops.addAll(this.logs);
        return drops;
    }

    private void markUpdated() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

