/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.event;

import com.mojang.logging.LogUtils;
import destiny.armoryofdestiny.client.render.blockentity.ArmorersAnvilRenderer;
import destiny.armoryofdestiny.client.render.blockentity.ArmorersTinkeringTableRenderer;
import destiny.armoryofdestiny.client.render.blockentity.BloomeryTopRenderer;
import destiny.armoryofdestiny.client.render.blockentity.NetherBloomeryTopRenderer;
import destiny.armoryofdestiny.server.registry.BlockEntityRegistry;
import destiny.armoryofdestiny.server.registry.BlockRegistry;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.util.UtilityVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        LOGGER.info("Loaded item colors");
        event.register((stack, colorIn) -> colorIn != 1 ? -1 : UtilityVariables.getBlueprintColor(stack), new ItemLike[]{(ItemLike)ItemRegistry.BLUEPRINT.get()});
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        LOGGER.info("Loaded block colors");
        event.register((blockState, blockAndTintGetter, blockPos, colorIn) -> colorIn != 1 ? -1 : UtilityVariables.getBlueprintColor((Level)Minecraft.m_91087_().f_91073_, blockPos), new Block[]{(Block)BlockRegistry.ARMORERS_TINKERING_TABLE.get()});
        event.register((blockState, blockAndTintGetter, blockPos, colorIn) -> colorIn != 1 ? -1 : UtilityVariables.getBlueprintColor((Level)Minecraft.m_91087_().f_91073_, blockPos), new Block[]{(Block)BlockRegistry.ARMORERS_ANVIL.get()});
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.ARMORERS_TINKERING_TABLE.get(), ArmorersTinkeringTableRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.BLOOMERY_TOP.get(), BloomeryTopRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.NETHER_BLOOMERY_TOP.get(), NetherBloomeryTopRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.ARMORERS_ANVIL.get(), ArmorersAnvilRenderer::new);
    }
}

