/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.event;

import destiny.armoryofdestiny.server.potion.NonexistenceEffect;
import destiny.armoryofdestiny.server.registry.EffectRegistry;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEvents {
    @SubscribeEvent
    public void vanillaGameEvent(VanillaGameEvent event) {
        Player player;
        Entity entity = event.getCause();
        if (entity instanceof Player && (player = (Player)entity).m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingChangeTarget(LivingChangeTargetEvent event) {
        if (event.getNewTarget() != null && event.getOriginalTarget().m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingTickEvent event) {
        Player player;
        Mob mob;
        LivingEntity livingEntity;
        LivingEntity livingEntity2;
        if (!event.getEntity().m_9236_().f_46443_ && (livingEntity2 = event.getEntity()) instanceof Mob && (livingEntity = (mob = (Mob)livingEntity2).m_5448_()) instanceof Player && (player = (Player)livingEntity).m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            mob.m_6710_(null);
        }
    }

    @SubscribeEvent
    public void livingExpireEffect(MobEffectEvent.Expired event) {
        if (event.getEffectInstance().m_19544_() instanceof NonexistenceEffect) {
            Level level = event.getEntity().m_9236_();
            LivingEntity entity = event.getEntity();
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, 0));
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.EDGE_OF_EXISTENCE_DEACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            Level level = event.getEntity().m_9236_();
            Player entity = event.getEntity();
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, 0));
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.EDGE_OF_EXISTENCE_DEACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        LivingEntity target;
        Level level = event.getEntity().m_9236_();
        Player attacker = event.getEntity();
        Entity attacked = event.getTarget();
        if (attacker.m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            if (attacked instanceof LivingEntity) {
                target = (LivingEntity)attacked;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 240, 1));
            }
            level.m_5594_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.EDGE_OF_EXISTENCE_DEACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (attacked instanceof LivingEntity && (target = (LivingEntity)attacked).m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        this.cancelNonExistenceOnHit(event);
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21205_();
            this.dragonSlayerDamageEvent(event, stack);
            this.bloodletterFillVesselsOnHit(stack, source, player);
            this.fillBloodletterOnHit(event, player);
        }
    }

    private void cancelNonExistenceOnHit(LivingHurtEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectRegistry.NONEXISTENCE.get())) {
            event.getEntity().m_21195_((MobEffect)EffectRegistry.NONEXISTENCE.get());
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, 0));
        }
    }

    private void dragonSlayerDamageEvent(LivingHurtEvent event, ItemStack stack) {
        if (stack.m_41720_() == ItemRegistry.DRAGON_SLAYER.get()) {
            if (stack.m_41783_() != null) {
                int damageStored = stack.m_41784_().m_128451_("damageDealt");
                stack.m_41784_().m_128405_("damageDealt", (int)((float)damageStored + event.getAmount()));
            } else {
                stack.m_41784_().m_128405_("damageDealt", (int)event.getAmount());
            }
        }
    }

    private void bloodletterFillVesselsOnHit(ItemStack stack, DamageSource source, Player player) {
        if (stack.m_41720_() == ItemRegistry.BLOODLETTER.get()) {
            Level level = source.m_7639_().m_9236_();
            ItemStack emptyVessels = null;
            for (ItemStack thisInventoryStack : player.m_150109_().f_35974_) {
                if (thisInventoryStack == null || thisInventoryStack.m_41720_() != ItemRegistry.BLOOD_VESSEL_EMPTY.get()) continue;
                emptyVessels = thisInventoryStack;
                break;
            }
            if (emptyVessels != null && (double)level.f_46441_.m_188501_() > 0.7) {
                player.m_36356_(new ItemStack((ItemLike)ItemRegistry.BLOOD_VESSEL_FULL.get(), 1));
                emptyVessels.m_41774_(1);
            }
        }
    }

    private void fillBloodletterOnHit(LivingHurtEvent event, Player player) {
        ItemStack bloodletter = null;
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (itemStack == null || itemStack.m_41720_() != ItemRegistry.BLOODLETTER.get()) continue;
            bloodletter = itemStack;
            break;
        }
        if (bloodletter != null) {
            if (bloodletter.m_41783_() != null) {
                if (0 >= bloodletter.m_41783_().m_128451_("abilityTick")) {
                    float damageStored = bloodletter.m_41784_().m_128451_("storedBlood");
                    bloodletter.m_41784_().m_128405_("storedBlood", (int)Math.min(200.0f, damageStored + event.getAmount()));
                }
            } else {
                bloodletter.m_41784_().m_128405_("storedBlood", (int)Math.min(200.0f, event.getAmount()));
            }
        }
    }
}

