/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.utility;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TooltipItem
extends Item {
    public TooltipItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        String itemName = this.getItemName(stack);
        String triviaTranslatable = this.getTriviaTranslatable();
        if (!triviaTranslatable.equals("tooltip.armoryofdestiny.none") && this.hasTrivia()) {
            MutableComponent trivia = Component.m_237115_((String)"tooltip.armoryofdestiny.trivia").m_130940_(ChatFormatting.DARK_GRAY);
            components.add((Component)trivia);
            MutableComponent trivia_title = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)(triviaTranslatable + ".title")).m_130940_(ChatFormatting.GRAY));
            components.add((Component)trivia_title);
            int triviaLines = this.getLineAmountTrivia(triviaTranslatable);
            for (int i = 1; i <= triviaLines; ++i) {
                MutableComponent trivia_description = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)(triviaTranslatable + ".description." + i)).m_130940_(ChatFormatting.DARK_GRAY));
                components.add((Component)trivia_description);
            }
        }
        if (this.hasAbilities()) {
            if (!this.isShift()) {
                ability = Component.m_237115_((String)"tooltip.armoryofdestiny.collapsed").m_7220_((Component)Component.m_237115_((String)"tooltip.armoryofdestiny.ability.collapsed").m_130940_(ChatFormatting.DARK_GRAY));
                components.add((Component)ability);
            } else {
                ability = Component.m_237115_((String)"tooltip.armoryofdestiny.expanded").m_7220_((Component)Component.m_237115_((String)"tooltip.armoryofdestiny.ability.expanded").m_130940_(ChatFormatting.DARK_GRAY));
                components.add((Component)ability);
                int abilityCount = this.getAbilityAmount(itemName);
                for (int i = 1; i <= abilityCount; ++i) {
                    MutableComponent ability_title = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)("item.armoryofdestiny." + itemName + ".ability." + i + ".title")).m_130940_(ChatFormatting.GRAY));
                    components.add((Component)ability_title);
                    int descriptionLineCount = this.getLineAmountAbility(itemName, i);
                    for (int ii = 1; ii <= descriptionLineCount; ++ii) {
                        MutableComponent ability_description = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)("item.armoryofdestiny." + itemName + ".ability." + i + ".description." + ii)).m_130940_(ChatFormatting.DARK_GRAY));
                        components.add((Component)ability_description);
                    }
                    String key = "item.armoryofdestiny." + itemName + ".ability." + i + ".cooldown";
                    MutableComponent component = Component.m_237115_((String)key);
                    if (component.getString().equals(key)) continue;
                    MutableComponent ability_cooldown = Component.m_237115_((String)"tooltip.armoryofdestiny.cooldown").m_7220_((Component)Component.m_237115_((String)"tooltip.armoryofdestiny.ability.cooldown").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.DARK_GRAY));
                    components.add((Component)ability_cooldown);
                }
            }
        }
    }

    public int getAbilityAmount(String itemName) {
        String key = "item.armoryofdestiny." + itemName + ".ability.";
        return this.getLineAmount(key, ".title");
    }

    public int getLineAmountAbility(String itemName, int abilityIndex) {
        String key = "item.armoryofdestiny." + itemName + ".ability." + abilityIndex + ".description.";
        return this.getLineAmount(key, null);
    }

    public int getLineAmountTrivia(String trivia) {
        String key = trivia + ".description.";
        return this.getLineAmount(key, null);
    }

    public int getLineAmount(String translatable, @Nullable String tail) {
        String key;
        MutableComponent component;
        int i = 1;
        if (tail == null) {
            tail = "";
        }
        while (!(component = Component.m_237115_((String)(key = translatable + i + tail))).getString().equals(key)) {
            ++i;
        }
        return i - 1;
    }

    public boolean isShift() {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)window, (int)340);
    }

    public boolean isControl() {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)window, (int)341);
    }

    public String getItemName(ItemStack stack) {
        return stack.m_41720_().toString();
    }

    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.none";
    }

    public boolean hasTrivia() {
        return true;
    }

    public boolean hasAbilities() {
        return true;
    }
}

