/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.BloodletterItemRenderer;
import destiny.armoryofdestiny.server.item.utility.TooltipAxeItem;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BloodletterItem
extends TooltipAxeItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final UUID ABILITY_MULTIPLIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C23A23DB6CF");
    public static final String ABILITY_TICK = "abilityTick";
    public static final String STORED_BLOOD = "storedBlood";
    public static final int maxBlood = 200;
    public static final int bloodPerTick = 10;
    public static final int bloodPerHit = 10;
    public static final int frameAmount = 15;
    private final float attackDamage;
    private final double attackSpeed;
    private final double attackKnockback;
    private final double entityReach;
    public float attackDamageAbility = 8.0f;
    public float attackSpeedAbility = 1.5f;
    public float attackKnockbackAbility = 1.0f;

    public BloodletterItem(Item.Properties build) {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, build);
        this.attackDamage = 7.0f;
        this.attackSpeed = 0.0;
        this.attackKnockback = -0.5;
        this.entityReach = 2.0;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BloodletterItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new BloodletterItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.STOP)});
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity1, LivingEntity entity2) {
        stack.m_41622_(1, entity2, entity3 -> entity3.m_21166_(EquipmentSlot.MAINHAND));
        entity1.f_19802_ = 0;
        if (stack.m_41783_() != null) {
            int abilityTick = stack.m_41783_().m_128451_(ABILITY_TICK);
            int storedBlood = stack.m_41783_().m_128451_(STORED_BLOOD);
            if (abilityTick > 0) {
                entity1.m_5496_((SoundEvent)SoundRegistry.BLOODLETTER_HIT.get(), 1.0f, 1.0f);
                stack.m_41784_().m_128405_(STORED_BLOOD, Math.max(0, storedBlood - 10));
            }
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41783_() != null) {
            int storedBlood = stack.m_41783_().m_128451_(STORED_BLOOD);
            int abilityTick = stack.m_41783_().m_128451_(ABILITY_TICK);
            if (storedBlood > 0 && abilityTick == 0) {
                stack.m_41784_().m_128405_(ABILITY_TICK, 1);
                level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.BLOODLETTER_ACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_(stack.m_41720_(), 60);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (abilityTick > 0) {
                stack.m_41784_().m_128405_(ABILITY_TICK, 0);
                level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.BLOODLETTER_DEACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_(stack.m_41720_(), 60);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (stack.m_41783_() != null && stack.m_41784_().m_128451_(ABILITY_TICK) > 0) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackDamageAbility, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackSpeedAbility, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackKnockbackAbility, AttributeModifier.Operation.ADDITION));
            }
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackKnockback, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.entityReach, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_(Items.f_42418_);
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.rapier";
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.0f, (float)0.8f, (float)0.9f);
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_(STORED_BLOOD) > 0;
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int storedBlood = stack.m_41783_().m_128451_(STORED_BLOOD);
            return Math.round((float)storedBlood / 200.0f * 13.0f);
        }
        return 0;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        if (this.isShift(level) && stack.m_41783_() != null) {
            MutableComponent damage_total = Component.m_237115_((String)"tooltip.line.dropdown").m_7220_((Component)Component.m_237115_((String)"item.armoryofdestiny.bloodletter.ability.1.stored_blood").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("" + stack.m_41783_().m_128451_(STORED_BLOOD))).m_130940_(ChatFormatting.DARK_GRAY));
            components.add((Component)damage_total);
        }
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean b) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41783_() != null) {
                int abilityTick = stack.m_41784_().m_128451_(ABILITY_TICK);
                int storedBlood = stack.m_41784_().m_128451_(STORED_BLOOD);
                if (storedBlood > 0) {
                    if (abilityTick > 0 && abilityTick < 15) {
                        stack.m_41784_().m_128405_(ABILITY_TICK, abilityTick + 1);
                    } else if (abilityTick == 15) {
                        stack.m_41784_().m_128405_(ABILITY_TICK, 1);
                        stack.m_41784_().m_128405_(STORED_BLOOD, Math.max(0, storedBlood - 10));
                    }
                } else if (abilityTick != 0) {
                    stack.m_41784_().m_128405_(ABILITY_TICK, 0);
                    level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.BLOODLETTER_DEACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }
}

